% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$select_feature}
\alias{AUTO_VI$select_feature}
\title{Select features from the check result}
\arguments{
\item{data}{Dataframe. A data frame where some columns represent
features and rows represent observations.}

\item{pattern}{Character. A regrex pattern to search for features.
See also \code{\link[=grep]{grep()}}.}
}
\value{
A tibble where columns represent
features and rows represent observations.
}
\description{
This function select features from the check result.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$feature_pca(data = self$check_result$observed, pattern = "f_")
}\if{html}{\out{</div>}}
}
}
\details{
By default, features are assumed to follow the naming convention
"f_(index)", where index is from one to the number of features.
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$lineup_check(extract_feature_from_layer = "global_max_pooling2d")
  myvi$select_feature()
}

}
