% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_wmd}
\alias{data_wmd}
\title{Data to Create Scaled SVD Object
Based on World Marriage Database}
\format{
A tibble with 6 rows and with columns
\code{version}, \code{type}, \code{labels_age},
\code{labels_sexgender}, \code{matrix}, and \code{offset}.
}
\source{
Derived from data from the
\emph{World Marriage Data 2019} database
available on the United Nations Population
Division website, and assembled by the
UNPD from national census and survey data.
}
\usage{
data_wmd
}
\description{
A subset of the data needed to produce
a scaled SVD object, derived from
data from the World Marriage Database.
The data is formatted using function
\code{data_ssvd_wmd()} in package \pkg{bssvd}.
}
\seealso{
\itemize{
\item \code{\link[=ssvd]{ssvd()}} Function to create scaled SVD objects
\item \link{WMD_C} Scaled SVD object based on a
full set of World Marriage Database data.
\item \link[=svds]{Scaled SVDs} Overview of scaled SVDs
implemented in \pkg{bage}
}
}
\keyword{datasets}
