% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_datamod_overcount}
\alias{set_datamod_overcount}
\title{Specify Overcount Data Model}
\usage{
set_datamod_overcount(mod, rate)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod_pois"},
created with \code{\link[=mod_pois]{mod_pois()}}.}

\item{rate}{The prior for the overcoverage rate.
A data frame with a variable
called \code{"mean"}, a variable called \code{"disp"},
and, optionally, one or more 'by' variables.}
}
\value{
A revised version of \code{mod}.
}
\description{
Specify a data model for the outcome
in a Poisson model, where the outcome
is subject to overcount
}
\details{
The overcount data model assumes that
reported values for the outcome overstate
the actual values. The reported values
might be affected by double-counting,
for instance, or might include some
people or events that are not in the target
population.
}
\section{The \code{rate} argument}{


The \code{rate} argument specifies a prior
distribution for the overcoverage
rate. \code{rate} is a
data frame with a variable called \code{"mean"},
a variable called \code{"disp"}, and, optionally,
one or more 'by' variables.
For instance, a  \code{rate} of

\if{html}{\out{<div class="sourceCode">}}\preformatted{data.frame(sex = c("Female", "Male"),
           mean = c(0.05, 0.03),
           disp = c(0.1, 0.15))
}\if{html}{\out{</div>}}

implies that the reported value
for the outcome is expected to
overstate the true value by about 5\%
for females, and about 3\% for females,
with greater unceratinty for males than females.
}

\section{Mathematical details}{


The model for the observed outcome is

\deqn{y_i^{\text{obs}} = y_i^{\text{true}} + \epsilon_i}
\deqn{\epsilon_i \sim \text{Poisson}(\kappa_{g[i]} \gamma_i w_i)}
\deqn{\kappa_g \sim \text{Gamma}(1/d_g, 1/(d_g m_g))}

where
\itemize{
\item \eqn{y_i^{\text{obs}}} is the observed outcome for cell \eqn{i};
\item \eqn{y_i^{\text{true}}} is the true outcome for cell \eqn{i};
\item \eqn{\epsilon_i} overcount in cell \eqn{i};
\item \eqn{\gamma_i} is the rate for cell \eqn{i};
\item \eqn{w_i} is exposure for cell \eqn{i};
\item \eqn{\kappa_{g[i]}} is the overcoverage rate for cell \eqn{i};
\item \eqn{m_g} is the expected value for \eqn{\kappa_g}
(specified via \code{rate}); and
\item \eqn{d_g} is disperson for \eqn{\kappa_g} (specified via \code{rate}).
}
}

\examples{
## specify 'rate'
rate <- data.frame(sex = c("Female", "Male"),
                   mean = c(0.1, 0.13),
                   disp = c(0.2, 0.2))

## specify model
mod <- mod_pois(divorces ~ age * sex + time,
                data = nzl_divorces,
                exposure = population) |>
  set_datamod_overcount(rate)
mod

## fit model
mod <- mod |>
  fit()
mod

## original data, plus imputed values for outcome
mod |>
  augment()

## parameter estimates
library(dplyr)
mod |>
  components() |>
  filter(term == "datamod")

## the data have in fact been confidentialized,
## so we account for that, in addition
## to accounting for overcoverage
mod <- mod |>
 set_confidential_rr3() |>
 fit()
mod
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=augment]{augment()}} Original data plus estimated values,
including estimates of true value for
the outcome variable
\item \code{\link[=components]{components()}} Estimated values for
model parameters, including inclusion
probabilities and overcount rates
\item \code{\link[=set_datamod_undercount]{set_datamod_undercount()}} An undercount-only
data model
\item \code{\link[=set_datamod_miscount]{set_datamod_miscount()}} An undercount-and-overcount
data model
\item \link{datamods} All data models implemented in \code{bage}
\item \link{confidential} Confidentialization
procedures modeled in \code{bage}
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
