% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggr_compare.R
\name{baggr_compare}
\alias{baggr_compare}
\title{(Run and) compare multiple baggr models}
\usage{
baggr_compare(
  ...,
  what = "pooling",
  compare = c("groups", "hyperpars", "effects"),
  transform = NULL,
  prob = 0.95,
  plot = FALSE
)
}
\arguments{
\item{...}{Either some (at least 1) objects of class \code{baggr}
(you should name your objects, see the example below)
or the same arguments you'd pass to \link{baggr}.
In the latter case you must specify \code{what} to compare.}

\item{what}{One of \code{"pooling"} (comparison between no, partial and
full pooling) or \code{"prior"} (comparison between prior and
posterior predictive). If pre-existing baggr models are
passed to \code{...}, this argument is ignored.}

\item{compare}{When plotting, choose between comparison of \code{"groups"}
(default), \code{"hyperpars"} (to omit group-specific estimates)
or (predicted) \code{"effects"}.
The \code{"groups"} option is not available when \code{what = "prior"}.}

\item{transform}{a function (e.g. exp(), log()) to apply to
the the sample of group (and hyper, if \code{hyper=TRUE})
effects before plotting; when working with
effects that are on log scale,
exponent transform is used automatically,
you can plot on log scale by setting
transform = identity}

\item{prob}{Width of uncertainty interval (defaults to 95\%)}

\item{plot}{logical; calls \link{plot.baggr_compare} when running \code{baggr_compare}}
}
\value{
an object of class \code{baggr_compare}
}
\description{
Compare multiple \link{baggr} models by either
providing multiple already existing models as (named) arguments or
passing parameters necessary to run a \link{baggr} model.
}
\details{
If you pass parameters to the function you must specify
what kind of comparison you want, either \code{"pooling"}, which
will run fully/partially/un-pooled models and then compare them,
or \code{"prior"} which will generate estimates without the data
and compare them to the model with the full data. For more
details see \link{baggr}, specifically the \code{ppd} argument.
}
\examples{
\donttest{
# Most basic comparison between no, partial and full pooling
# (This will run the models)
# run model with just prior and then full data for comparison
# with the same arguments that are passed to baggr
prior_comparison <-
  baggr_compare(schools,
                model = 'rubin',
                #this is just for illustration -- don't set it this low normally!
                iter = 500,
                prior_hypermean = normal(0, 3),
                prior_hypersd = normal(0,2),
                prior_hypercor = lkj(2),
                what = "prior")
# print the aggregated treatment effects
prior_comparison
# plot the comparison of the two distributions
plot(prior_comparison)
# Now compare different types of pooling for the same model
pooling_comparison <-
  baggr_compare(schools,
                model = 'rubin',
                #this is just for illustration -- don't set it this low normally!
                iter = 500,
                prior_hypermean = normal(0, 3),
                prior_hypersd = normal(0,2),
                prior_hypercor = lkj(2),
                what = "pooling",
                # You can automatically plot:
                plot = TRUE)
# Compare existing models (you don't have to, but best to name them):
bg1 <- baggr(schools, pooling = "partial")
bg2 <- baggr(schools, pooling = "full")
baggr_compare("Partial pooling model" = bg1, "Full pooling" = bg2)

#' ...or simply draw from prior predictive dist (note ppd=T)
bg1 <- baggr(schools, ppd=TRUE)
bg2 <- baggr(schools, prior_hypermean = normal(0, 5), ppd=TRUE)
baggr_compare("Prior A, p.p.d."=bg1,
              "Prior B p.p.d."=bg2,
              compare = "effects")

# Compare how posterior predictive effect varies with e.g. choice of prior
bg1 <- baggr(schools, prior_hypersd = uniform(0, 20))
bg2 <- baggr(schools, prior_hypersd = normal(0, 5))
baggr_compare("Uniform prior on SD"=bg1,
                   "Normal prior on SD"=bg2,
                   compare = "effects", plot = TRUE)

# Models don't have to be identical. Compare different subsets of input data:
bg1_small <- baggr(schools[1:6,], pooling = "partial")
baggr_compare("8 schools model" = bg1, "First 6 schools" = bg1_small,
              plot = TRUE)
}
}
\seealso{
\link{plot.baggr_compare} and \link{print.baggr_compare}
for working with results of this function
}
\author{
Witold Wiecek, Brice Green
}
