% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfittedICAR.R
\name{plot.fittedICAR}
\alias{plot.fittedICAR}
\title{Plot 1D ICAR model fitted to aoristic data}
\usage{
\method{plot}{fittedICAR}(
  x,
  hpd = c(0.5, 0.9),
  minortick = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = "Probability Mass",
  calendar = "BP",
  col1 = "steelblue",
  col2 = "lightblue",
  pch = 20,
  plot.legend = TRUE,
  legend.arg = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{fittedICAR} class object}

\item{hpd}{A vector with two values defining the highest posterior density interval to display. Default is 0.5 and 0.9.}

\item{minortick}{Interval for minor ticks in the x-axis label. Default is estimated based on timescale.}

\item{ylim}{Limits of the y-axis. Default estimated from posterior ranges.}

\item{xlab}{Label for the x-axis. Default based on \code{calendar}.}

\item{ylab}{Label for the y-axis. Default is "Probability Mass".}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the x-axis should be displayed in BP or BC/AD. Default is \code{'BP'}.}

\item{col1}{Fill color for the first (inner) HPD interval. Default is 'steelblue'.}

\item{col2}{Fill color for the second (outer) HPD interval. Default is 'lightblue'.}

\item{pch}{Point symbol used to display mean posteriors. Default is 20.}

\item{plot.legend}{Logical indicating whether to display a legend or not (default is TRUE).}

\item{legend.arg}{List containing arguments to be directed to the \code{legend()} function.}

\item{...}{Additional arguments affecting the plot.}
}
\value{
No return value (plot function)
}
\description{
Plot posterior estimates of \code{fittedICAR} class objects.
}
