% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_coordinates_from_locality.R
\name{bdc_coordinates_from_locality}
\alias{bdc_coordinates_from_locality}
\title{Identify records lacking or with invalid coordinates but containing locality
information}
\usage{
bdc_coordinates_from_locality(
  data,
  lat = "decimalLatitude",
  lon = "decimalLongitude",
  locality = "locality",
  save_outputs = FALSE
)
}
\arguments{
\item{data}{data.frame. Containing geographical coordinates and the column
"locality'.}

\item{lat}{character string. The column name with latitude in decimal degrees
and WGS84. Default = "decimalLatitude".}

\item{lon}{character string. The column with longitude in decimal degrees and
WGS84. Default = "decimalLongitude".}

\item{locality}{character string. The column name with locality information.
Default = "locality".}

\item{save_outputs}{logical. Should a table containing transposed coordinates
saved for further inspection? Default = FALSE.}
}
\value{
A data.frame containing records missing or with invalid coordinates
but with potentially useful locality information. When save_outputs = FALSE
the data.frame is saved in Output/Check/01_coordinates_from_locality.csv
}
\description{
This function Identifies records whose coordinates can potentially be
extracted from locality information.
}
\details{
According to DarwinCore terminology, locality refers to "the
specific description of the place" where an organism was recorded.
}
\examples{
x <- data.frame(
  lat = c(NA, NA, ""), 
  lon = c("", NA, NA), 
  locality = c("PARAGUAY: ALTO PARAGUAY: CO.; 64KM W PUERTO SASTRE", 
               "Parque Estadual da Serra de Caldas Novas, Goias, Brazil", 
               "Parque Nacional Iguazu"))

bdc_coordinates_from_locality(
data = x, 
lat = "lat", 
lon = "lon", 
locality = "locality", 
save_outputs = FALSE)

}
\seealso{
Other prefilter: 
\code{\link{bdc_basisOfRecords_notStandard}()},
\code{\link{bdc_coordinates_country_inconsistent}()},
\code{\link{bdc_coordinates_empty}()},
\code{\link{bdc_coordinates_outOfRange}()},
\code{\link{bdc_coordinates_transposed}()},
\code{\link{bdc_country_standardized}()},
\code{\link{bdc_scientificName_empty}()}
}
\concept{prefilter}
