// Generated by rstantools.  Do not edit by hand.

/*
    bennu is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bennu is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bennu.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_distribution_covariate_model_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 108, column 2 to column 33)",
                                                      " (in 'string', line 109, column 2 to column 22)",
                                                      " (in 'string', line 110, column 2 to column 21)",
                                                      " (in 'string', line 111, column 2 to column 11)",
                                                      " (in 'string', line 112, column 2 to column 25)",
                                                      " (in 'string', line 113, column 2 to column 21)",
                                                      " (in 'string', line 117, column 2 to column 30)",
                                                      " (in 'string', line 118, column 2 to column 22)",
                                                      " (in 'string', line 148, column 2 to column 24)",
                                                      " (in 'string', line 150, column 2 to column 27)",
                                                      " (in 'string', line 151, column 2 to column 40)",
                                                      " (in 'string', line 152, column 2 to column 22)",
                                                      " (in 'string', line 153, column 2 to column 35)",
                                                      " (in 'string', line 154, column 2 to column 28)",
                                                      " (in 'string', line 155, column 2 to column 36)",
                                                      " (in 'string', line 156, column 2 to column 45)",
                                                      " (in 'string', line 158, column 4 to column 39)",
                                                      " (in 'string', line 162, column 10 to line 163, column 90)",
                                                      " (in 'string', line 164, column 10 to column 62)",
                                                      " (in 'string', line 161, column 21 to line 165, column 5)",
                                                      " (in 'string', line 161, column 4 to line 165, column 5)",
                                                      " (in 'string', line 166, column 4 to column 53)",
                                                      " (in 'string', line 157, column 22 to line 167, column 3)",
                                                      " (in 'string', line 157, column 2 to line 167, column 3)",
                                                      " (in 'string', line 169, column 2 to column 43)",
                                                      " (in 'string', line 170, column 2 to column 42)",
                                                      " (in 'string', line 171, column 2 to column 45)",
                                                      " (in 'string', line 173, column 4 to line 174, column 52)",
                                                      " (in 'string', line 172, column 22 to line 175, column 3)",
                                                      " (in 'string', line 172, column 2 to line 175, column 3)",
                                                      " (in 'string', line 123, column 2 to column 33)",
                                                      " (in 'string', line 124, column 2 to column 39)",
                                                      " (in 'string', line 126, column 2 to column 18)",
                                                      " (in 'string', line 127, column 2 to column 22)",
                                                      " (in 'string', line 128, column 2 to column 21)",
                                                      " (in 'string', line 136, column 6 to column 51)",
                                                      " (in 'string', line 135, column 23 to line 137, column 5)",
                                                      " (in 'string', line 135, column 4 to line 137, column 5)",
                                                      " (in 'string', line 133, column 7 to line 138, column 3)",
                                                      " (in 'string', line 131, column 6 to column 35)",
                                                      " (in 'string', line 130, column 19 to line 132, column 5)",
                                                      " (in 'string', line 130, column 4 to line 132, column 5)",
                                                      " (in 'string', line 129, column 18 to line 133, column 3)",
                                                      " (in 'string', line 129, column 2 to line 138, column 3)",
                                                      " (in 'string', line 140, column 2 to column 74)",
                                                      " (in 'string', line 143, column 4 to column 53)",
                                                      " (in 'string', line 142, column 25 to line 144, column 3)",
                                                      " (in 'string', line 142, column 2 to line 144, column 3)",
                                                      " (in 'string', line 52, column 2 to column 38)",
                                                      " (in 'string', line 54, column 2 to column 31)",
                                                      " (in 'string', line 56, column 2 to column 24)",
                                                      " (in 'string', line 58, column 2 to column 19)",
                                                      " (in 'string', line 60, column 2 to column 17)",
                                                      " (in 'string', line 62, column 2 to column 29)",
                                                      " (in 'string', line 64, column 2 to column 22)",
                                                      " (in 'string', line 65, column 2 to column 21)",
                                                      " (in 'string', line 67, column 2 to column 26)",
                                                      " (in 'string', line 69, column 2 to column 21)",
                                                      " (in 'string', line 70, column 8 to column 13)",
                                                      " (in 'string', line 70, column 2 to column 33)",
                                                      " (in 'string', line 72, column 8 to column 21)",
                                                      " (in 'string', line 72, column 2 to column 59)",
                                                      " (in 'string', line 74, column 8 to column 21)",
                                                      " (in 'string', line 74, column 2 to column 52)",
                                                      " (in 'string', line 76, column 8 to column 9)",
                                                      " (in 'string', line 76, column 2 to column 22)",
                                                      " (in 'string', line 78, column 8 to column 16)",
                                                      " (in 'string', line 78, column 17 to column 20)",
                                                      " (in 'string', line 78, column 2 to column 35)",
                                                      " (in 'string', line 80, column 8 to column 21)",
                                                      " (in 'string', line 80, column 2 to column 48)",
                                                      " (in 'string', line 82, column 8 to column 21)",
                                                      " (in 'string', line 82, column 2 to column 41)",
                                                      " (in 'string', line 84, column 2 to column 26)",
                                                      " (in 'string', line 85, column 2 to column 28)",
                                                      " (in 'string', line 86, column 2 to column 14)",
                                                      " (in 'string', line 87, column 2 to column 16)",
                                                      " (in 'string', line 91, column 9 to column 19)",
                                                      " (in 'string', line 91, column 2 to column 36)",
                                                      " (in 'string', line 92, column 9 to column 19)",
                                                      " (in 'string', line 92, column 2 to column 44)",
                                                      " (in 'string', line 93, column 2 to column 18)",
                                                      " (in 'string', line 94, column 9 to column 12)",
                                                      " (in 'string', line 94, column 13 to column 16)",
                                                      " (in 'string', line 94, column 2 to column 41)",
                                                      " (in 'string', line 96, column 2 to column 99)",
                                                      " (in 'string', line 98, column 4 to column 115)",
                                                      " (in 'string', line 99, column 4 to column 45)",
                                                      " (in 'string', line 97, column 25 to line 100, column 3)",
                                                      " (in 'string', line 97, column 2 to line 100, column 3)",
                                                      " (in 'string', line 102, column 2 to column 52)",
                                                      " (in 'string', line 104, column 2 to column 73)",
                                                      " (in 'string', line 108, column 8 to column 21)",
                                                      " (in 'string', line 112, column 8 to column 16)",
                                                      " (in 'string', line 113, column 8 to column 11)",
                                                      " (in 'string', line 117, column 8 to column 21)",
                                                      " (in 'string', line 148, column 8 to column 9)",
                                                      " (in 'string', line 150, column 8 to column 9)",
                                                      " (in 'string', line 151, column 8 to column 16)",
                                                      " (in 'string', line 151, column 17 to column 20)",
                                                      " (in 'string', line 152, column 8 to column 9)",
                                                      " (in 'string', line 153, column 8 to column 16)",
                                                      " (in 'string', line 153, column 17 to column 20)",
                                                      " (in 'string', line 154, column 9 to column 10)",
                                                      " (in 'string', line 155, column 8 to column 11)",
                                                      " (in 'string', line 156, column 8 to column 11)",
                                                      " (in 'string', line 14, column 6 to column 30)",
                                                      " (in 'string', line 15, column 6 to column 42)",
                                                      " (in 'string', line 16, column 13 to column 14)",
                                                      " (in 'string', line 16, column 6 to column 49)",
                                                      " (in 'string', line 18, column 10 to line 19, column 71)",
                                                      " (in 'string', line 17, column 21 to line 20, column 7)",
                                                      " (in 'string', line 17, column 6 to line 20, column 7)",
                                                      " (in 'string', line 21, column 6 to column 25)",
                                                      " (in 'string', line 13, column 44 to line 22, column 3)",
                                                      " (in 'string', line 25, column 4 to column 35)",
                                                      " (in 'string', line 26, column 12 to column 20)",
                                                      " (in 'string', line 26, column 4 to column 28)",
                                                      " (in 'string', line 28, column 6 to column 37)",
                                                      " (in 'string', line 27, column 4 to line 28, column 37)",
                                                      " (in 'string', line 29, column 4 to column 18)",
                                                      " (in 'string', line 24, column 28 to line 30, column 3)",
                                                      " (in 'string', line 34, column 11 to column 12)",
                                                      " (in 'string', line 34, column 14 to column 15)",
                                                      " (in 'string', line 34, column 4 to column 19)",
                                                      " (in 'string', line 35, column 4 to column 16)",
                                                      " (in 'string', line 38, column 8 to column 24)",
                                                      " (in 'string', line 42, column 10 to column 21)",
                                                      " (in 'string', line 41, column 13 to line 43, column 9)",
                                                      " (in 'string', line 40, column 10 to column 27)",
                                                      " (in 'string', line 39, column 45 to line 41, column 9)",
                                                      " (in 'string', line 39, column 8 to line 43, column 9)",
                                                      " (in 'string', line 37, column 21 to line 44, column 7)",
                                                      " (in 'string', line 37, column 6 to line 44, column 7)",
                                                      " (in 'string', line 36, column 19 to line 45, column 5)",
                                                      " (in 'string', line 36, column 4 to line 45, column 5)",
                                                      " (in 'string', line 46, column 4 to column 13)",
                                                      " (in 'string', line 33, column 52 to line 47, column 3)"};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
convolve(const T0__& x_arg__, const T1__& rev_pmf_arg__,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& x = to_ref(x_arg__);
  const auto& rev_pmf = to_ref(rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 107;
    t = num_elements(x);
    int max_pmf;
    max_pmf = std::numeric_limits<int>::min();
    
    current_statement__ = 108;
    max_pmf = num_elements(rev_pmf);
    current_statement__ = 109;
    validate_non_negative_index("conv_cases", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> conv_cases;
    conv_cases = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(conv_cases, DUMMY_VAR__);
    
    current_statement__ = 110;
    assign(conv_cases, nil_index_list(), rep_vector(1e-5, t),
      "assigning variable conv_cases");
    current_statement__ = 113;
    for (int s = 1; s <= t; ++s) {
      current_statement__ = 111;
      assign(conv_cases, cons_list(index_uni(s), nil_index_list()),
        (conv_cases[(s - 1)] +
          dot_product(
            rvalue(x,
              cons_list(index_min_max(std::max(1, ((s - max_pmf) + 1)), s),
                nil_index_list()), "x"), tail(rev_pmf, std::min(max_pmf, s)))),
        "assigning variable conv_cases");}
    current_statement__ = 114;
    return conv_cases;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct convolve_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& x, const T1__& rev_pmf, std::ostream* pstream__)  const 
{
return convolve(x, rev_pmf, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
rev_func(const T0__& x_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& x = to_ref(x_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n_points;
    n_points = std::numeric_limits<int>::min();
    
    current_statement__ = 116;
    n_points = num_elements(x);
    current_statement__ = 117;
    validate_non_negative_index("x_rev", "n_points", n_points);
    Eigen::Matrix<local_scalar_t__, -1, 1> x_rev;
    x_rev = Eigen::Matrix<local_scalar_t__, -1, 1>(n_points);
    stan::math::fill(x_rev, DUMMY_VAR__);
    
    current_statement__ = 120;
    for (int i = 1; i <= n_points; ++i) {
      current_statement__ = 119;
      assign(x_rev, cons_list(index_uni(i), nil_index_list()),
        x[(((n_points - i) + 1) - 1)], "assigning variable x_rev");}
    current_statement__ = 121;
    return x_rev;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rev_func_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
operator()(const T0__& x, std::ostream* pstream__)  const 
{
return rev_func(x, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
to_triangular_convolution(const T0__& x_arg__, const int& K,
                          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& x = to_ref(x_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 123;
    validate_non_negative_index("y", "K", K);
    current_statement__ = 124;
    validate_non_negative_index("y", "K", K);
    Eigen::Matrix<local_scalar_t__, -1, -1> y;
    y = Eigen::Matrix<local_scalar_t__, -1, -1>(K, K);
    stan::math::fill(y, DUMMY_VAR__);
    
    int pos;
    pos = std::numeric_limits<int>::min();
    
    current_statement__ = 126;
    pos = 1;
    current_statement__ = 136;
    for (int i = 1; i <= K; ++i) {
      current_statement__ = 134;
      for (int j = 1; j <= K; ++j) {
        current_statement__ = 127;
        pos = ((i + 1) - j);
        current_statement__ = 132;
        if ((primitive_value(logical_gt(pos, 0)) && primitive_value(
            logical_lte(pos, num_elements(x))))) {
          current_statement__ = 130;
          assign(y,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())), x[(pos - 1)],
            "assigning variable y");
        } else {
          current_statement__ = 128;
          assign(y,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())), 0,
            "assigning variable y");
        }}}
    current_statement__ = 137;
    return y;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct to_triangular_convolution_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
operator()(const T0__& x, const int& K, std::ostream* pstream__)  const 
{
return to_triangular_convolution(x, K, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_distribution_covariate_model final : public model_base_crtp<model_distribution_covariate_model> {
private:
  int run_estimation;
  int rw_type;
  int N_region;
  int N_t;
  int N;
  int N_distributed;
  double alpha;
  double beta;
  int max_delays;
  int N_psi;
  std::vector<double> psi;
  std::vector<int> regions;
  std::vector<int> times;
  std::vector<int> Orders;
  std::vector<std::vector<int>> Orders2D;
  std::vector<int> Reported_Distributed;
  std::vector<int> Reported_Used;
  double mu0_sigma;
  double sigma_sigma;
  double mu0_mu;
  double sigma_mu;
  Eigen::Matrix<double, -1, 1> distribute_pmf;
  Eigen::Matrix<double, -1, 1> reverse_distribute_pmf;
  double trunc_lpmf;
  Eigen::Matrix<double, -1, -1> reporting_delay_matrix;
 
public:
  ~model_distribution_covariate_model() { }
  
  inline std::string model_name() const final { return "model_distribution_covariate_model"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_distribution_covariate_model(stan::io::var_context& context__,
                                     unsigned int random_seed__ = 0,
                                     std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_distribution_covariate_model_namespace::model_distribution_covariate_model";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 49;
      context__.validate_dims("data initialization","run_estimation","int",
          context__.to_vec());
      run_estimation = std::numeric_limits<int>::min();
      
      current_statement__ = 49;
      run_estimation = context__.vals_i("run_estimation")[(1 - 1)];
      current_statement__ = 49;
      current_statement__ = 49;
      check_greater_or_equal(function__, "run_estimation", run_estimation, 0);
      current_statement__ = 49;
      current_statement__ = 49;
      check_less_or_equal(function__, "run_estimation", run_estimation, 1);
      current_statement__ = 50;
      context__.validate_dims("data initialization","rw_type","int",
          context__.to_vec());
      rw_type = std::numeric_limits<int>::min();
      
      current_statement__ = 50;
      rw_type = context__.vals_i("rw_type")[(1 - 1)];
      current_statement__ = 50;
      current_statement__ = 50;
      check_greater_or_equal(function__, "rw_type", rw_type, 1);
      current_statement__ = 50;
      current_statement__ = 50;
      check_less_or_equal(function__, "rw_type", rw_type, 2);
      current_statement__ = 51;
      context__.validate_dims("data initialization","N_region","int",
          context__.to_vec());
      N_region = std::numeric_limits<int>::min();
      
      current_statement__ = 51;
      N_region = context__.vals_i("N_region")[(1 - 1)];
      current_statement__ = 51;
      current_statement__ = 51;
      check_greater_or_equal(function__, "N_region", N_region, 0);
      current_statement__ = 52;
      context__.validate_dims("data initialization","N_t","int",
          context__.to_vec());
      N_t = std::numeric_limits<int>::min();
      
      current_statement__ = 52;
      N_t = context__.vals_i("N_t")[(1 - 1)];
      current_statement__ = 52;
      current_statement__ = 52;
      check_greater_or_equal(function__, "N_t", N_t, 0);
      current_statement__ = 53;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 53;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 53;
      current_statement__ = 53;
      check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 54;
      context__.validate_dims("data initialization","N_distributed","int",
          context__.to_vec());
      N_distributed = std::numeric_limits<int>::min();
      
      current_statement__ = 54;
      N_distributed = context__.vals_i("N_distributed")[(1 - 1)];
      current_statement__ = 54;
      current_statement__ = 54;
      check_greater_or_equal(function__, "N_distributed", N_distributed, 0);
      current_statement__ = 55;
      context__.validate_dims("data initialization","alpha","double",
          context__.to_vec());
      alpha = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 55;
      alpha = context__.vals_r("alpha")[(1 - 1)];
      current_statement__ = 55;
      current_statement__ = 55;
      check_greater_or_equal(function__, "alpha", alpha, 0);
      current_statement__ = 56;
      context__.validate_dims("data initialization","beta","double",
          context__.to_vec());
      beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 56;
      beta = context__.vals_r("beta")[(1 - 1)];
      current_statement__ = 56;
      current_statement__ = 56;
      check_greater_or_equal(function__, "beta", beta, 0);
      current_statement__ = 57;
      context__.validate_dims("data initialization","max_delays","int",
          context__.to_vec());
      max_delays = std::numeric_limits<int>::min();
      
      current_statement__ = 57;
      max_delays = context__.vals_i("max_delays")[(1 - 1)];
      current_statement__ = 57;
      current_statement__ = 57;
      check_greater_or_equal(function__, "max_delays", max_delays, 0);
      current_statement__ = 58;
      context__.validate_dims("data initialization","N_psi","int",
          context__.to_vec());
      N_psi = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      N_psi = context__.vals_i("N_psi")[(1 - 1)];
      current_statement__ = 58;
      current_statement__ = 58;
      check_greater_or_equal(function__, "N_psi", N_psi, 0);
      current_statement__ = 59;
      validate_non_negative_index("psi", "N_psi", N_psi);
      current_statement__ = 60;
      context__.validate_dims("data initialization","psi","double",
          context__.to_vec(N_psi));
      psi = std::vector<double>(N_psi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 60;
      assign(psi, nil_index_list(), context__.vals_r("psi"),
        "assigning variable psi");
      current_statement__ = 60;
      for (int sym1__ = 1; sym1__ <= N_psi; ++sym1__) {
        current_statement__ = 60;
        current_statement__ = 60;
        check_greater_or_equal(function__, "psi[sym1__]", psi[(sym1__ - 1)],
                               0);}
      current_statement__ = 61;
      validate_non_negative_index("regions", "N_distributed", N_distributed);
      current_statement__ = 62;
      context__.validate_dims("data initialization","regions","int",
          context__.to_vec(N_distributed));
      regions = std::vector<int>(N_distributed, std::numeric_limits<int>::min());
      
      current_statement__ = 62;
      assign(regions, nil_index_list(), context__.vals_i("regions"),
        "assigning variable regions");
      current_statement__ = 62;
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        current_statement__ = 62;
        current_statement__ = 62;
        check_greater_or_equal(function__, "regions[sym1__]",
                               regions[(sym1__ - 1)], 1);}
      current_statement__ = 62;
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        current_statement__ = 62;
        current_statement__ = 62;
        check_less_or_equal(function__, "regions[sym1__]",
                            regions[(sym1__ - 1)], N_region);}
      current_statement__ = 63;
      validate_non_negative_index("times", "N_distributed", N_distributed);
      current_statement__ = 64;
      context__.validate_dims("data initialization","times","int",
          context__.to_vec(N_distributed));
      times = std::vector<int>(N_distributed, std::numeric_limits<int>::min());
      
      current_statement__ = 64;
      assign(times, nil_index_list(), context__.vals_i("times"),
        "assigning variable times");
      current_statement__ = 64;
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        current_statement__ = 64;
        current_statement__ = 64;
        check_greater_or_equal(function__, "times[sym1__]",
                               times[(sym1__ - 1)], 1);}
      current_statement__ = 64;
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        current_statement__ = 64;
        current_statement__ = 64;
        check_less_or_equal(function__, "times[sym1__]", times[(sym1__ - 1)],
                            N_t);}
      current_statement__ = 65;
      validate_non_negative_index("Orders", "N", N);
      current_statement__ = 66;
      context__.validate_dims("data initialization","Orders","int",
          context__.to_vec(N));
      Orders = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 66;
      assign(Orders, nil_index_list(), context__.vals_i("Orders"),
        "assigning variable Orders");
      current_statement__ = 67;
      validate_non_negative_index("Orders2D", "N_region", N_region);
      current_statement__ = 68;
      validate_non_negative_index("Orders2D", "N_t", N_t);
      current_statement__ = 69;
      context__.validate_dims("data initialization","Orders2D","int",
          context__.to_vec(N_region, N_t));
      Orders2D = std::vector<std::vector<int>>(N_region, std::vector<int>(N_t, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> Orders2D_flat__;
        current_statement__ = 69;
        assign(Orders2D_flat__, nil_index_list(),
          context__.vals_i("Orders2D"), "assigning variable Orders2D_flat__");
        current_statement__ = 69;
        pos__ = 1;
        current_statement__ = 69;
        for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
          current_statement__ = 69;
          for (int sym2__ = 1; sym2__ <= N_region; ++sym2__) {
            current_statement__ = 69;
            assign(Orders2D,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Orders2D_flat__[(pos__ - 1)], "assigning variable Orders2D");
            current_statement__ = 69;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 70;
      validate_non_negative_index("Reported_Distributed", "N_distributed",
                                  N_distributed);
      current_statement__ = 71;
      context__.validate_dims("data initialization","Reported_Distributed",
          "int",context__.to_vec(N_distributed));
      Reported_Distributed = std::vector<int>(N_distributed, std::numeric_limits<int>::min());
      
      current_statement__ = 71;
      assign(Reported_Distributed, nil_index_list(),
        context__.vals_i("Reported_Distributed"),
        "assigning variable Reported_Distributed");
      current_statement__ = 72;
      validate_non_negative_index("Reported_Used", "N_distributed",
                                  N_distributed);
      current_statement__ = 73;
      context__.validate_dims("data initialization","Reported_Used","int",
          context__.to_vec(N_distributed));
      Reported_Used = std::vector<int>(N_distributed, std::numeric_limits<int>::min());
      
      current_statement__ = 73;
      assign(Reported_Used, nil_index_list(),
        context__.vals_i("Reported_Used"), "assigning variable Reported_Used");
      current_statement__ = 74;
      context__.validate_dims("data initialization","mu0_sigma","double",
          context__.to_vec());
      mu0_sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 74;
      mu0_sigma = context__.vals_r("mu0_sigma")[(1 - 1)];
      current_statement__ = 74;
      current_statement__ = 74;
      check_greater_or_equal(function__, "mu0_sigma", mu0_sigma, 0);
      current_statement__ = 75;
      context__.validate_dims("data initialization","sigma_sigma","double",
          context__.to_vec());
      sigma_sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 75;
      sigma_sigma = context__.vals_r("sigma_sigma")[(1 - 1)];
      current_statement__ = 75;
      current_statement__ = 75;
      check_greater_or_equal(function__, "sigma_sigma", sigma_sigma, 0);
      current_statement__ = 76;
      context__.validate_dims("data initialization","mu0_mu","double",
          context__.to_vec());
      mu0_mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 76;
      mu0_mu = context__.vals_r("mu0_mu")[(1 - 1)];
      current_statement__ = 77;
      context__.validate_dims("data initialization","sigma_mu","double",
          context__.to_vec());
      sigma_mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 77;
      sigma_mu = context__.vals_r("sigma_mu")[(1 - 1)];
      current_statement__ = 78;
      validate_non_negative_index("distribute_pmf", "max_delays", max_delays);
      current_statement__ = 79;
      distribute_pmf = Eigen::Matrix<double, -1, 1>(max_delays);
      stan::math::fill(distribute_pmf, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 80;
      validate_non_negative_index("reverse_distribute_pmf", "max_delays",
                                  max_delays);
      current_statement__ = 81;
      reverse_distribute_pmf = Eigen::Matrix<double, -1, 1>(max_delays);
      stan::math::fill(reverse_distribute_pmf, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 82;
      trunc_lpmf = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 83;
      validate_non_negative_index("reporting_delay_matrix", "N_t", N_t);
      current_statement__ = 84;
      validate_non_negative_index("reporting_delay_matrix", "N_t", N_t);
      current_statement__ = 85;
      reporting_delay_matrix = Eigen::Matrix<double, -1, -1>(N_t, N_t);
      stan::math::fill(reporting_delay_matrix, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 86;
      trunc_lpmf = log_diff_exp(gamma_lcdf((max_delays + 1), alpha, beta),
                     gamma_lcdf(1, alpha, beta));
      current_statement__ = 90;
      for (int i = 1; i <= max_delays; ++i) {
        double distribute_lpmf;
        distribute_lpmf = std::numeric_limits<double>::quiet_NaN();
        
        current_statement__ = 87;
        distribute_lpmf = (log_diff_exp(gamma_lcdf((i + 1), alpha, beta),
                             gamma_lcdf(i, alpha, beta)) - trunc_lpmf);
        current_statement__ = 88;
        assign(distribute_pmf, cons_list(index_uni(i), nil_index_list()),
          stan::math::exp(distribute_lpmf),
          "assigning variable distribute_pmf");}
      current_statement__ = 91;
      assign(reverse_distribute_pmf, nil_index_list(),
        rev_func(distribute_pmf, pstream__),
        "assigning variable reverse_distribute_pmf");
      current_statement__ = 92;
      assign(reporting_delay_matrix, nil_index_list(),
        to_triangular_convolution(to_vector(psi), N_t, pstream__),
        "assigning variable reporting_delay_matrix");
      current_statement__ = 93;
      validate_non_negative_index("logp", "N_distributed", N_distributed);
      current_statement__ = 94;
      validate_non_negative_index("c", "N_region", N_region);
      current_statement__ = 95;
      validate_non_negative_index("ct", "N_t", N_t);
      current_statement__ = 96;
      validate_non_negative_index("p", "N_distributed", N_distributed);
      current_statement__ = 97;
      validate_non_negative_index("sim_used", "N", N);
      current_statement__ = 98;
      validate_non_negative_index("Distributed", "N", N);
      current_statement__ = 99;
      validate_non_negative_index("Distributed2D", "N_region", N_region);
      current_statement__ = 100;
      validate_non_negative_index("Distributed2D", "N_t", N_t);
      current_statement__ = 101;
      validate_non_negative_index("sim_p", "N", N);
      current_statement__ = 102;
      validate_non_negative_index("sim_p2D", "N_region", N_region);
      current_statement__ = 103;
      validate_non_negative_index("sim_p2D", "N_t", N_t);
      current_statement__ = 104;
      validate_non_negative_index("sim_actual_used", "N", N);
      current_statement__ = 105;
      validate_non_negative_index("region_distributed", "N_t", N_t);
      current_statement__ = 106;
      validate_non_negative_index("convolve_region_distributed", "N_t", N_t);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += N_distributed;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += N_region;
      num_params_r__ += N_t;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_distribution_covariate_model_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> logp;
      logp = std::vector<local_scalar_t__>(N_distributed, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        current_statement__ = 1;
        assign(logp, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable logp");}
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 2;
      sigma = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 2;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      local_scalar_t__ zeta;
      zeta = DUMMY_VAR__;
      
      current_statement__ = 3;
      zeta = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        zeta = stan::math::lb_constrain(zeta, 0, lp__);
      } else {
        current_statement__ = 3;
        zeta = stan::math::lb_constrain(zeta, 0);
      }
      local_scalar_t__ mu0;
      mu0 = DUMMY_VAR__;
      
      current_statement__ = 4;
      mu0 = in__.scalar();
      std::vector<local_scalar_t__> c;
      c = std::vector<local_scalar_t__>(N_region, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_region; ++sym1__) {
        current_statement__ = 5;
        assign(c, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable c");}
      std::vector<local_scalar_t__> ct;
      ct = std::vector<local_scalar_t__>(N_t, DUMMY_VAR__);
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        current_statement__ = 6;
        assign(ct, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable ct");}
      std::vector<local_scalar_t__> p;
      p = std::vector<local_scalar_t__>(N_distributed, DUMMY_VAR__);
      
      current_statement__ = 8;
      assign(p, nil_index_list(), inv_logit(logp), "assigning variable p");
      {
        current_statement__ = 31;
        lp_accum__.add(normal_lpdf<propto__>(mu0, mu0_mu, mu0_sigma));
        current_statement__ = 32;
        lp_accum__.add(normal_lpdf<propto__>(sigma, sigma_mu, sigma_sigma));
        current_statement__ = 33;
        lp_accum__.add(normal_lpdf<propto__>(c, 0, 1));
        current_statement__ = 34;
        lp_accum__.add(normal_lpdf<propto__>(ct[(1 - 1)], 0, 1));
        current_statement__ = 35;
        lp_accum__.add(normal_lpdf<propto__>(zeta, 0, 1));
        current_statement__ = 44;
        if (logical_eq(rw_type, 1)) {
          current_statement__ = 42;
          for (int i = 2; i <= N_t; ++i) {
            current_statement__ = 40;
            lp_accum__.add(
              normal_lpdf<propto__>(ct[(i - 1)], ct[((i - 1) - 1)], zeta));}
        } else {
          current_statement__ = 38;
          for (int i = 1; i <= (N_t - 2); ++i) {
            current_statement__ = 36;
            lp_accum__.add(
              normal_lpdf<propto__>(
                ((ct[(i - 1)] - (2 * ct[((i + 1) - 1)])) + ct[((i + 2) - 1)]),
                0, zeta));}
        }
        current_statement__ = 45;
        lp_accum__.add(
          normal_lpdf<propto__>(logp,
            add(
              add(mu0,
                to_vector(
                  rvalue(c,
                    cons_list(index_multi(regions), nil_index_list()), "c"))),
              to_vector(
                rvalue(ct, cons_list(index_multi(times), nil_index_list()),
                  "ct"))), sigma));
        current_statement__ = 48;
        if (logical_eq(run_estimation, 1)) {
          current_statement__ = 46;
          lp_accum__.add(
            binomial_lpmf<propto__>(Reported_Used, Reported_Distributed, p));
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_distribution_covariate_model_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> logp;
      logp = std::vector<double>(N_distributed, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        current_statement__ = 1;
        assign(logp, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable logp");}
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma = in__.scalar();
      current_statement__ = 2;
      sigma = stan::math::lb_constrain(sigma, 0);
      double zeta;
      zeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      zeta = in__.scalar();
      current_statement__ = 3;
      zeta = stan::math::lb_constrain(zeta, 0);
      double mu0;
      mu0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      mu0 = in__.scalar();
      std::vector<double> c;
      c = std::vector<double>(N_region, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N_region; ++sym1__) {
        current_statement__ = 5;
        assign(c, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable c");}
      std::vector<double> ct;
      ct = std::vector<double>(N_t, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        current_statement__ = 6;
        assign(ct, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable ct");}
      std::vector<double> p;
      p = std::vector<double>(N_distributed, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        vars__.emplace_back(logp[(sym1__ - 1)]);}
      vars__.emplace_back(sigma);
      vars__.emplace_back(zeta);
      vars__.emplace_back(mu0);
      for (int sym1__ = 1; sym1__ <= N_region; ++sym1__) {
        vars__.emplace_back(c[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        vars__.emplace_back(ct[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 8;
      assign(p, nil_index_list(), inv_logit(logp), "assigning variable p");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
          vars__.emplace_back(p[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<int> sim_used;
      sim_used = std::vector<int>(N, std::numeric_limits<int>::min());
      
      std::vector<int> Distributed;
      Distributed = std::vector<int>(N, std::numeric_limits<int>::min());
      
      std::vector<std::vector<int>> Distributed2D;
      Distributed2D = std::vector<std::vector<int>>(N_region, std::vector<int>(N_t, std::numeric_limits<int>::min()));
      
      std::vector<double> sim_p;
      sim_p = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<std::vector<double>> sim_p2D;
      sim_p2D = std::vector<std::vector<double>>(N_region, std::vector<double>(N_t, std::numeric_limits<double>::quiet_NaN()));
      
      Eigen::Matrix<double, -1, 1> sim_actual_used;
      sim_actual_used = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(sim_actual_used, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<int> region_distributed;
      region_distributed = std::vector<int>(N_t, std::numeric_limits<int>::min());
      
      std::vector<int> convolve_region_distributed;
      convolve_region_distributed = std::vector<int>(N_t, std::numeric_limits<int>::min());
      
      current_statement__ = 24;
      for (int i = 1; i <= N_region; ++i) {
        current_statement__ = 17;
        assign(region_distributed, nil_index_list(),
          rvalue(Orders2D,
            cons_list(index_uni(i),
              cons_list(index_omni(), nil_index_list())), "Orders2D"),
          "assigning variable region_distributed");
        current_statement__ = 21;
        for (int s = 1; s <= N_t; ++s) {
          current_statement__ = 18;
          assign(convolve_region_distributed,
            cons_list(index_uni(s), nil_index_list()),
            sum(
              binomial_rng(
                rvalue(region_distributed,
                  cons_list(
                    index_min_max(std::max(1, ((s - max_delays) + 1)), s),
                    nil_index_list()), "region_distributed"),
                tail(reverse_distribute_pmf, std::min(max_delays, s)),
                base_rng__)),
            "assigning variable convolve_region_distributed");
          current_statement__ = 19;
          assign(sim_p2D,
            cons_list(index_uni(i),
              cons_list(index_uni(s), nil_index_list())),
            normal_rng(((mu0 + c[(i - 1)]) + ct[(s - 1)]), sigma, base_rng__),
            "assigning variable sim_p2D");}
        current_statement__ = 22;
        assign(Distributed2D,
          cons_list(index_uni(i), cons_list(index_omni(), nil_index_list())),
          convolve_region_distributed, "assigning variable Distributed2D");}
      current_statement__ = 25;
      assign(Distributed, nil_index_list(), to_array_1d(Distributed2D),
        "assigning variable Distributed");
      current_statement__ = 26;
      assign(sim_p, nil_index_list(), inv_logit(to_array_1d(sim_p2D)),
        "assigning variable sim_p");
      current_statement__ = 27;
      assign(sim_used, nil_index_list(),
        binomial_rng(Distributed, sim_p, base_rng__),
        "assigning variable sim_used");
      current_statement__ = 30;
      for (int i = 1; i <= N_region; ++i) {
        current_statement__ = 28;
        assign(sim_actual_used,
          cons_list(index_min_max((1 + ((i - 1) * N_t)), (i * N_t)),
            nil_index_list()),
          mdivide_left_tri_low(reporting_delay_matrix,
            segment(to_vector(sim_used), (1 + ((i - 1) * N_t)), N_t)),
          "assigning variable sim_actual_used");}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(sim_used[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(Distributed[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_region; ++sym2__) {
          vars__.emplace_back(Distributed2D[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(sim_p[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_region; ++sym2__) {
          vars__.emplace_back(sim_p2D[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(sim_actual_used[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        vars__.emplace_back(region_distributed[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        vars__.emplace_back(convolve_region_distributed[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> logp;
      logp = std::vector<double>(N_distributed, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(logp, nil_index_list(), context__.vals_r("logp"),
        "assigning variable logp");
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      double zeta;
      zeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      zeta = context__.vals_r("zeta")[(1 - 1)];
      double zeta_free__;
      zeta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      zeta_free__ = stan::math::lb_free(zeta, 0);
      double mu0;
      mu0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      mu0 = context__.vals_r("mu0")[(1 - 1)];
      std::vector<double> c;
      c = std::vector<double>(N_region, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(c, nil_index_list(), context__.vals_r("c"),
        "assigning variable c");
      std::vector<double> ct;
      ct = std::vector<double>(N_t, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      assign(ct, nil_index_list(), context__.vals_r("ct"),
        "assigning variable ct");
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        vars__.emplace_back(logp[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_free__);
      vars__.emplace_back(zeta_free__);
      vars__.emplace_back(mu0);
      for (int sym1__ = 1; sym1__ <= N_region; ++sym1__) {
        vars__.emplace_back(c[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        vars__.emplace_back(ct[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("logp");
    names__.emplace_back("sigma");
    names__.emplace_back("zeta");
    names__.emplace_back("mu0");
    names__.emplace_back("c");
    names__.emplace_back("ct");
    names__.emplace_back("p");
    names__.emplace_back("sim_used");
    names__.emplace_back("Distributed");
    names__.emplace_back("Distributed2D");
    names__.emplace_back("sim_p");
    names__.emplace_back("sim_p2D");
    names__.emplace_back("sim_actual_used");
    names__.emplace_back("region_distributed");
    names__.emplace_back("convolve_region_distributed");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(N_distributed)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_region)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_t)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(N_distributed)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_region),
                                             static_cast<size_t>(N_t)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_region),
                                             static_cast<size_t>(N_t)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_t)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_t)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "logp" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "zeta");
    param_names__.emplace_back(std::string() + "mu0");
    for (int sym1__ = 1; sym1__ <= N_region; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "ct" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "p" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sim_used" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Distributed" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_region; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Distributed2D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sim_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_region; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sim_p2D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sim_actual_used" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "region_distributed" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "convolve_region_distributed" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "logp" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "zeta");
    param_names__.emplace_back(std::string() + "mu0");
    for (int sym1__ = 1; sym1__ <= N_region; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "ct" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_distributed; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "p" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sim_used" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "Distributed" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_region; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "Distributed2D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sim_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N_region; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sim_p2D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sim_actual_used" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "region_distributed" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_t; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "convolve_region_distributed" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"logp\",\"type\":{\"name\":\"array\",\"length\":" << N_distributed << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"zeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c\",\"type\":{\"name\":\"array\",\"length\":" << N_region << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"ct\",\"type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"p\",\"type\":{\"name\":\"array\",\"length\":" << N_distributed << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"sim_used\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Distributed\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Distributed2D\",\"type\":{\"name\":\"array\",\"length\":" << N_region << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"sim_p\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"sim_p2D\",\"type\":{\"name\":\"array\",\"length\":" << N_region << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"sim_actual_used\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"region_distributed\",\"type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"convolve_region_distributed\",\"type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"logp\",\"type\":{\"name\":\"array\",\"length\":" << N_distributed << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"zeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"c\",\"type\":{\"name\":\"array\",\"length\":" << N_region << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"ct\",\"type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"p\",\"type\":{\"name\":\"array\",\"length\":" << N_distributed << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"sim_used\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Distributed\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"Distributed2D\",\"type\":{\"name\":\"array\",\"length\":" << N_region << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"sim_p\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"sim_p2D\",\"type\":{\"name\":\"array\",\"length\":" << N_region << ",\"element_type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"real\"}}},\"block\":\"generated_quantities\"},{\"name\":\"sim_actual_used\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"region_distributed\",\"type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"convolve_region_distributed\",\"type\":{\"name\":\"array\",\"length\":" << N_t << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_distribution_covariate_model_namespace::model_distribution_covariate_model;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_distribution_covariate_model_namespace::profiles__;
}
#endif
#endif
