% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{ADHD}
\alias{ADHD}
\title{ADHD Symptom Checklist for Children Aged 6–8 Years}
\format{
A matrix with 355 rows and 19 columns.
\describe{
  \item{group}{ADHD diagnosis: 1 = diagnosed, 0 = not diagnosed}
  \item{avoid}{Often avoids, dislikes, or is reluctant to engage in tasks
  that require sustained mental effort (I)}
  \item{closeatt}{Often fails to give close attention to details or makes
  careless mistakes in schoolwork, work, or other activities (I)}
  \item{distract}{Is often easily distracted by extraneous stimuli (I)}
  \item{forget}{Is often forgetful in daily activities (I)}
  \item{instruct}{Often does not follow through on instructions and fails to
  finish schoolwork, chores, or duties in the workplace (I)}
  \item{listen}{Often does not seem to listen when spoken to directly
  (I)}
  \item{loses}{Often loses things necessary for tasks or activities (I)}
  \item{org}{Often has difficulty organizing tasks and activities (I)}
  \item{susatt}{Often has difficulty sustaining attention in tasks or play
  activities (I)}
  \item{blurts}{Often blurts out answers before questions have been completed
  (HI)}
  \item{fidget}{Often fidgets with hands or feet or squirms in seat
  (HI)}
  \item{interrupt}{Often interrupts or intrudes on others (HI)}
  \item{motor}{Is often "on the go" or often acts as if "driven by a motor"
  (HI)}
  \item{quiet}{Often has difficulty playing or engaging in leisure activities
  quietly (HI)}
  \item{runs}{Often runs about or climbs excessively in situations in which
  it is inappropriate (HI)}
  \item{seat}{Often leaves seat in classroom or in other situations in which
  remaining seated is expected (HI)}
  \item{talks}{Often talks excessively (HI)}
  \item{turn}{Often has difficulty awaiting turn (HI)}
}
}
\source{
\insertCite{Silk_2019_ADHD;textual}{bgms}.
Data retrieved from \doi{doi:10.1371/journal.pone.0211053.s004}.
Licensed under the CC-BY 4.0: https://creativecommons.org/licenses/by/4.0/
}
\usage{
data("ADHD")
}
\description{
This dataset includes ADHD symptom ratings for 355 children aged 6 to 8 years from the
Children’s Attention Project (CAP) cohort \insertCite{Silk_2019_ADHD}{bgms}. The sample
consists of 146 children diagnosed with ADHD and 209 without a diagnosis. Symptoms were
assessed through structured interviews with parents using the NIMH Diagnostic Interview
Schedule for Children IV (DISC-IV) \insertCite{Shaffer_2000_nimh}{bgms}. The checklist
includes 18 items: 9 Inattentive (I) and 9 Hyperactive/Impulsive (HI). Each item is binary
(1 = present, 0 = absent).
}
\references{
\insertAllCited{}
}
\keyword{datasets}
