% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-stats.R
\name{bike_stored_files}
\alias{bike_stored_files}
\title{Get names of files read into database}
\usage{
bike_stored_files(bikedb, city)
}
\arguments{
\item{bikedb}{A string containing the path to the SQLite3 database.}

\item{city}{Optional city for which filenames are to be obtained}
}
\description{
Get names of files read into database
}
\examples{
\dontrun{
data_dir <- tempdir ()
bike_write_test_data (data_dir = data_dir)
bikedb <- file.path (data_dir, 'testdb')
store_bikedata (data_dir = data_dir, bikedb = bikedb)
files <- bike_stored_files (bikedb = bikedb)
# returns a tibble with names of all stored files

bike_rm_test_data (data_dir = data_dir)
bike_rm_db (bikedb)
# don't forget to remove real data!
# file.remove (list.files ('.', pattern = '.zip'))
}
}
