% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic_fit.R
\name{fit_dynamic_inactivation}
\alias{fit_dynamic_inactivation}
\title{Fitting of Dynamic Inactivation Models}
\usage{
fit_dynamic_inactivation(experiment_data, simulation_model, temp_profile,
  starting_points, upper_bounds, lower_bounds, known_params, ...,
  minimize_log = TRUE, tol0 = 1e-05)
}
\arguments{
\item{experiment_data}{data frame with the experimental data to be adjusted.
It must have a column named \dQuote{time} and another one named
\dQuote{N}.}

\item{simulation_model}{character identifying the model to be used.}

\item{temp_profile}{data frame with discrete values of the temperature for
each time. It must have one column named \code{time} and another named
\code{temperature} providing discrete values of the temperature at
time points.}

\item{starting_points}{starting values of the parameters for the adjustment.}

\item{upper_bounds}{named numerical vector defining the upper bounds of the
parameters for the adjustment.}

\item{lower_bounds}{named numerical vector defining the lower bounds of the
parameters for the adjustment.}

\item{known_params}{named numerical vector with the fixed (i.e., not
adjustable) model parameters.}

\item{...}{further arguments passed to \code{\link{modFit}}}

\item{minimize_log}{logical. If \code{TRUE}, the adjustment is based on the
minimization of the error of the logarithmic count. \code{TRUE} by
default.}

\item{tol0}{numeric. Observations at time 0 make Weibull-based models singular.
The time for observatins taken at time 0 are changed for this value.}
}
\value{
A list of class \code{FitInactivation} with the following items:
     \itemize{
         \item fit_results: a list of class \code{modFit} with the info
               of the adjustment.
         \item best_prediction: a list of class \code{SimulInactivation}
               with prediction made by the adjusted model.
         \item data: a data frame with the data used for the fitting.
         }
}
\description{
Fits the parameters of an inactivation model to experimental data.
The function \code{\link{modFit}} of the package \code{\link{FME}} is
used for the adjustment.
}
\examples{
## EXAMPLE 1 ------

data(dynamic_inactivation)  # The example data set is used.

get_model_data()  # Retrieve the valid model keys.

simulation_model <- "Peleg"  # Peleg's model will be used

model_data <- get_model_data(simulation_model)
model_data$parameters  # Set the model parameters

dummy_temp <- data.frame(time = c(0, 1.25, 2.25, 4.6),
                         temperature = c(70, 105, 105, 70))  # Dummy temp. profile

## Set known parameters and initial points/bounds for unknown ones

known_params = c(temp_crit = 100)

starting_points <- c(n = 1, k_b = 0.25, N0 = 1e+05)
upper_bounds <- c(n = 2, k_b = 1, N0 = Inf)
lower_bounds <- c(n = 0, k_b = 0, N0 = 1e4)

dynamic_fit <- fit_dynamic_inactivation(dynamic_inactivation, simulation_model,
                                        dummy_temp, starting_points,
                                        upper_bounds, lower_bounds,
                                        known_params)

plot(dynamic_fit)
goodness_of_fit(dynamic_fit)

## END EXAMPLE 1 -----

}
\seealso{
\code{\link{modFit}}
}
