data_org<-function(pred, m, y, refy = rep(NA, ncol(data.frame(y))),
                   predref = rep(NA, ncol(data.frame(pred))), 
                   deltap = NA, 
                   deltam = NA, 
                   mref = rep(NA, ncol(data.frame(m))),cova = NULL, cova.ref=list(),
                   mcov = NULL, mcov.ref=list(), mclist=NULL,complete=FALSE)  
  #mcov is the data frame with all covariates for TVs, mind is the indicator for covariates
  #if mclist is null but not mcov, mcov is applied to all tvs.
  #if both mcov and mclist are not NULL, the first item of mclist lists all tvs that are using different mcov, the following items gives the mcov for the tv in order.
  # use NA is no mcov to be used. e.g. mclist=list(c(1,2,4),l1=1,l2=NA,l4=c(1,3)),mediator 1 use mcov[,1], 2 uses no, 4 uses mcov[,c(1,3)], all other mediators use all  
  # can use variables names too in the mclist
  #complete=TRUE if only completed cases will be used.
  #ref.cova is the reference group for the categorical variable in cova
{#turn a categorical variable M2[,cat1] to binary dummy variables
bin_cat <- function(M2, M1, cat1, catref = 1)
#M2 is the original data frame
#cat1 is the column number of the categorical variable in M2
#catref is the reference group
{a <- factor(M2[, cat1])
 b <- sort(unique(a[a != catref]))
 d<-NULL
 e<-rep(1,nrow(M2))
 for(i in 1:length(b))
   {d=cbind(d,ifelse(a==b[i],1,0))
    e=ifelse(a==b[i],i+1,e)
    }
 d[is.na(M2[,cat1]),]=NA
 e[is.na(M2[,cat1])]=NA
 M2[,cat1]=e
 xnames=colnames(M1)
 M1=cbind(M1,d)
 colnames(M1)=c(xnames,paste(colnames(M2)[cat1],b,sep="."))
 list(M1=M1,M2=M2,cat=c(ncol(M1)-ncol(d)+1,ncol(M1)))
} #M1 is the created dataframe with the binarized categorical variable, 
  #with cat is the starting and ending column numbers in M1 for the categorical variable
  #M2 is the original data frame and the categorical variable is 1 to k. k is the total number of categories

#find the position of char2 in char1
order_char<-function(char1,char2)
{a<-1:length(char1)
b<-NULL
for (i in 1:length(char2))
  b<-c(b,a[char1==char2[i]])
b
}

# Function to binarize categorical or factor variables with specified reference groups
binarize_categorical <- function(data, reference_groups = list()) {
  # Identify categorical or factor variables
  categorical_vars <- sapply(data, function(x) is.factor(x) || is.character(x))
  
  # Initialize an empty list to store the binarized columns
  binarized_list <- list()
  
  # Loop through each column
  for (col in names(data)) {
    if (categorical_vars[col]) {
      # Get unique levels of the factor variable
      levels <- unique(data[[col]])
      
      # Determine the reference group
      reference_group <- ifelse(col %in% names(reference_groups), reference_groups[[col]], levels[1])
      
      # Create binary columns for each level except the reference group
      for (level in levels[levels != reference_group]) {
        binary_col <- as.integer(data[[col]] == level)
        col_name <- paste(col, level, sep = "_")
        binarized_list[[col_name]] <- binary_col
      }
    } else {
      # If not a categorical variable, keep the original column
      binarized_list[[col]] <- data[[col]]
    }
  }
  
  # Convert the list to a data frame
  data_binarized <- as.data.frame(binarized_list)
  
  return(data_binarized)
}

###start the main code
#clean up the outcomes:y_type=type of outcomes;
#y_type=2:binary, 3:category, 1:continuous, 4:time-to-event
#consider only 1 outcome for now

#consider only complete case if complete=TRUE
if (complete){
data.temp=cbind(pred,m,y)
if (!is.null(mcov) & !is.null(mclist))
  data.temp=cbind(pred,m,y,mcov)
if(!is.null(cova))
  data.temp=cbind(data.temp,cova)
choose.temp=complete.cases(data.temp)
if(ncol(data.frame(pred))==1)
  pred=pred[choose.temp]
else
  pred=pred[choose.temp,]
if(ncol(data.frame(y))==1)
  y=y[choose.temp]
else
  y=y[choose.temp,]
if(ncol(data.frame(m))==1)
  m=m[choose.temp]
else
  m=m[choose.temp,]
if(!is.null(cova)){
if(ncol(data.frame(cova))==1)
  cova=cova[choose.temp]
else
  cova=cova[choose.temp,]}
if(!is.null(mcov)){
if(ncol(data.frame(mcov))==1)
  mcov=mcov[choose.temp]
else
  mcov=mcov[choose.temp,]}
}

#find out the variable format for y (y_type)
if (!is(y,"Surv"))
  {if (nlevels(droplevels(as.factor(y))) == 2) {#binary
    y_type <- 2
    if (!is.na(refy))
      y1 <- ifelse(y == refy, 0, 1)
    else {
      refy <- levels(droplevels(as.factor(y)))[1]
      y1 <- ifelse(as.factor(y) == refy,0, 1)
      }
    }
  else if (is.character(y) | is.factor(y)) {#categorical
    y_type <- 3
    y1 <- droplevels(y)
    if (is.na(refy))
      refy <- levels(as.factor(y1))[1]
    temp=bin_cat(as.matrix(y1),NULL,1,refy)
    y=temp$M2 #remove factor(e) since categorical y is also numeric in mbart
    y1=temp$M1
    }
  else  #continuous
    {y_type = 1
     y1=y}
  }
else
{y_type<-4
 y1=cbind(y[,1],y[,2])}

#clean up names, cova, and mcov
  if (!is.null(cova)) {
    if (is.null(colnames(cova)))
      cova_names = paste("cova",1:ncol(data.frame(cova)),sep=".")
    else
      cova_names = colnames(cova)
    cova=data.frame(cova)
    colnames(cova)=cova_names
    cova=binarize_categorical(cova,reference_groups=cova.ref)
  }

  if (!is.null(mcov)){
    if (is.null(colnames(mcov)))
      mcov_names = paste("mcov",1:ncol(data.frame(mcov)),sep=".")
    else mcov_names = colnames(mcov)
    mcov=data.frame(mcov)
    colnames(mcov)=mcov_names
    mcov=binarize_categorical(mcov,reference_groups=mcov.ref)
  }
  mnames <- colnames(m)
  pred_names = names(pred)

##prepare for the predictor(s)
  pred1 <- data.frame(pred) #original format
  pred2 <- NULL             #all transformed
  pred2_names = NULL
#  pred3 <- NULL             #transformed continuous predictors with pred+delta(pred)
#  pred3_names = NULL
  if (is.null(pred_names))
    pred_names = paste("pred",1:ncol(pred1),sep='')
  colnames(pred1) = pred_names
  binpred = NULL   #binary predictor in pred2
  catpred = NULL   #categorical predictor in pred2, each row is for one categorical predictor
  contpred = NULL  #continuos predictor in pred2, each row is for a continuous predictor
  binpred1 = NULL  #binary predictor in pred1
  catpred1 = NULL  #categorical predictor in pred1
  contpred1 = NULL #continuous predictor in pred1
  npred = ncol(pred1)
  n1=nrow(pred1)

  if(is.na(deltap))
    {xgp=TRUE
     deltap=rep(1,ncol(data.frame(pred)))}
  else
    xgp=FALSE

  for (i in 1:npred)
    if (nlevels(droplevels(as.factor(pred1[,i]))) == 2) { #binary predictor
    if (!is.na(predref[i]))
     {pred2 <- cbind(pred2,ifelse(pred1[, i] == predref[i],0, 1))
#      pred3 <- cbind(pred3,ifelse(pred1[, i] == predref[i],0, 1))
      pred1[,i] <- ifelse(pred1[, i] == predref[i],0, 1)}
    else {
      temp.pred <- as.factor(pred1[, i])
      pred2 <- cbind(pred2,ifelse(temp.pred == levels(droplevels(temp.pred))[1], 0, 1))
#      pred3 <- cbind(pred3,ifelse(temp.pred == levels(droplevels(temp.pred))[1], 0, 1))
      pred1[,i] <- ifelse(temp.pred == levels(droplevels(temp.pred))[1], 0, 1)
    }
    binpred1 = c(binpred1, i)
    pred2_names=c(pred2_names,pred_names[i])
    binpred = c(binpred,ncol(pred2))
    }
  else if (is.character(pred1[, i]) | is.factor(pred1[, i])) { #category predictor
    pred1[, i] = droplevels(pred1[, i]) #remove empty levels
    if(!is.null(pred2))
      colnames(pred2)=pred2_names
    if (!is.na(predref[i]))
      pred.temp1 <- bin_cat(pred1, pred2, i, predref[i])
    else
      pred.temp1 <- bin_cat(pred1, pred2, i, levels(as.factor(pred1[,i]))[1])
    pred2 = pred.temp1$M1
    pred1 = pred.temp1$M2
#    pred3 = cbind(pred3,pred.temp1$M1[,pred.temp1$cat[1]:pred.temp1$cat[2]])
    catpred1 = c(catpred1,i)
    catpred = rbind(catpred,pred.temp1$cat)
    pred2_names = colnames(pred.temp1$M1)
  }
  else #consider the transformation of continuous x
    {contpred1 = c(contpred1, i)
     pred2<-cbind(pred2,pred1[,i])
     if(xgp)
       deltap[i]=sd(pred1[,i],na.rm=TRUE)/10
#     pred3 = cbind(pred3,pred1[,i]+deltap[i]) #deltap is the changing amount for predictors
     contpred = c(contpred,ncol(pred2))
     pred2_names=c(pred2_names,pred_names[i])
    }

 colnames(pred2)=pred2_names
# colnames(pred3)=pred2_names

## prepare mediators for y
 m1 <- data.frame(m) #original format
 m2 <- NULL             #all transformed
 m2_names = NULL
 m3.1 <- NULL             #transformed continuous mediators with mediator+delta(med)
 m3.2 <- NULL             #transformed continuous mediators with mediator+delta(med)
 m3_names = NULL
 if (is.null(mnames))
   mnames = paste("m",1:ncol(m1),sep='')
 colnames(m1) = mnames
 binm = NULL
 catm = NULL
 contm = NULL
 binm1 = NULL
 catm1 = NULL
 contm1 = NULL
 contm3 = NULL         #index for m3 and m.cont.dev
 nm = ncol(m1)
 n2=nrow(m1)
 if(is.na(deltam))
 {xgm=TRUE
  deltam=rep(1,ncol(data.frame(m)))}
 else
   xgm=FALSE
 for (i in 1:nm)
   if (nlevels(droplevels(as.factor(m1[,i]))) == 2) { #binary mediator
     if (!is.na(mref[i]))
     {m2 <- cbind(m2,ifelse(m1[, i] == mref[i],0, 1))
     m3.1 <- cbind(m3.1,ifelse(m1[, i] == mref[i],0, 1))
     m3.2 <- cbind(m3.2,ifelse(m1[, i] == mref[i],0, 1))
     m1[,i] <- ifelse(m1[, i] == mref[i],0, 1)}
     else 
     {temp.m <- as.factor(m1[, i])
      m2 <- cbind(m2,ifelse(temp.m == levels(droplevels(temp.m))[1], 0, 1))
      m3.1<-cbind(m3.1,ifelse(temp.m == levels(droplevels(temp.m))[1], 0, 1))
      m3.2<-cbind(m3.2,ifelse(temp.m == levels(droplevels(temp.m))[1], 0, 1))
      m1[,i] <- ifelse(temp.m == levels(droplevels(temp.m))[1], 0, 1)}
     binm1 = c(binm1, i)
     m2_names=c(m2_names,mnames[i])
     colnames(m2)=m2_names
     binm = c(binm,ncol(m2))
   }
  else if (is.character(m1[, i]) | is.factor(m1[, i])) { #category mediator
   m1[, i] = droplevels(as.factor(m1[, i]))
   if (!is.na(mref[i]))
     m.temp1 <- bin_cat(m1, m2, i, mref[i])
   else
     m.temp1 <- bin_cat(m1, m2, i, levels(as.factor(m1[,i]))[1])
   m2 = m.temp1$M1
   m1 = m.temp1$M2
   m3.1 = cbind(m3.1,m.temp1$M1[,m.temp1$cat[1]:m.temp1$cat[2]])
   m3.2 = cbind(m3.2,m.temp1$M1[,m.temp1$cat[1]:m.temp1$cat[2]])
   catm1 = c(catm1,i)
   catm = rbind(catm,m.temp1$cat)
   m2_names = c(m2_names, colnames(m.temp1$M1)[m.temp1$cat[1]:m.temp1$cat[2]])
   colnames(m2)=m2_names
 }
 else #consider the transformation of continuous m
 {contm1 = c(contm1, i)
  m2<-cbind(m2,m1[,i])
  if(xgm)
    deltam[i]=sd(m1[,i],na.rm=TRUE)/10
  m3.1= cbind(m3.1,m1[,i]-deltam[i]/2) #deltam is the changing amount for mediators
  m3.2= cbind(m3.2,m1[,i]+deltam[i]/2) #deltam is the changing amount for mediators
  m2_names=c(m2_names,mnames[i])
  colnames(m2)=m2_names
  contm=c(contm,ncol(m2))
 }

 colnames(m2)=m2_names
 colnames(m3.1)=m2_names
 colnames(m3.2)=m2_names
 
 p1=ifelse(is.null(contm1),0,length(contm1))
 p2=ifelse(is.null(binm1),0,length(binm1))
 p3=ifelse(is.null(catm1),0,length(catm1))
 p=p1+p2+p3
  
 #prepare for covariates of mediators
 if(is.null(mcov))
  mind=NULL
 else
 {mind=matrix(T,p,ncol(mcov))
  mcov.nm2=colnames(mcov)
  colnames(mind)=mcov.nm2
  rownames(mind)=mnames
  if (!is.null(mclist))
  {if (is.character(mclist[[1]]))  #mclist[[1]] lists the number/name of mediators in m with different mcov
    mclist[[1]]=match(mclist[[1]],mnames)  #change to column numbers
#   mcov=data.frame(mcov,no=rep(0,nrow(mcov)))  #add a column of 0 in mcov
#   mind=matrix(rep(1:(ncol(mcov)-1),each=p),p,ncol(mcov)-1)
   for (i in 1:length(mclist[[1]]))
   {if(is.na(mclist[[i+1]]))
     mind[mclist[[1]][i],]=F
    else {temp=NULL
     for (j in mclist[[i+1]])
      if(is.character(j))
       temp=c(temp,grep(j,mcov.nm2))
      else
       temp=c(temp,grep(mcov_names[j],mcov.nm2))
      mind[mclist[[1]][i],-temp]=F
 }}
 }}  #if mcov is not NULL, mind is a matrix of rows # of mediator, collunms number of mcov, cell is the indicator
 #of whether the column of mcov should be used for mediator i in m1
 

 results = list(N=nrow(data.frame(y)), y_type=y_type, y=y, y1=y1,
                cova=cova,npred=npred,nm=nm,mcov=mcov,mind=mind,
                pred1=pred1,pred2=pred2, #pred3=pred3,  
                binpred2=binpred, catpred2=catpred, contpred2=contpred, 
                binpred1=binpred1, catpred1=catpred1,contpred1=contpred1,
                m1=m1, m2=m2, m3.1=m3.1, m3.2=m3.2, p1=p1, p2=p2, p3=p3,
                binm2=binm, catm2=catm, contm2=contm,
                binm1=binm1, catm1=catm1, contm1=contm1,deltap=deltap,deltam=deltam)
 return(results)
}



bma.bart<- function(pred, m, y, refy = rep(NA, ncol(data.frame(y))),
                    predref = rep(NA, ncol(data.frame(pred))), 
                    deltap = NA, deltam = NA, 
                    mref = rep(NA, ncol(data.frame(m))),cova = NULL,cova.ref=list(),
                    mcov = NULL, mcov.ref=list(), mclist=NULL,complete=FALSE,#tmax=NULL,multi=NULL,
                    ntree=200L, numcut=100L,                       #parameters for trees of mediator
                    ndpost=1000L, nskip=100L, keepevery=1L,        #see ?wbart  
                    nkeeptrain=ndpost, nkeeptest=ndpost,
                    nkeeptestmean=ndpost, nkeeptreedraws=ndpost,
                    printevery=100L,seed=sample(1:1000000,1))
{median_survival_time<-function(surv_probs,ntime,time_points)
{data.temp=matrix(surv_probs,ncol=ntime,byrow=T)
median_survival_times <- apply(data.temp, 1, function(surv_probs) {
  median_time <- time_points[which.min(abs(surv_probs - 0.5))]
  return(median_time)
})}

#clean up data
data0<- data_org(pred=pred, m=m, y=y, refy=refy, predref=predref, deltap=deltap, 
                 deltam=deltam, mref=mref, cova=cova, cova.ref=cova.ref, 
                 mcov = mcov, mcov.ref=mcov.ref, mclist=mclist,complete=complete)
y.type=data0$y_type #1 for continuous outcome, 4 for time-to-event, 2 for binary, 3 for categorical
N=data0$N
x=data0$pred2 #all exposures with binarized categories, k-class categorical variable are considered as k-1 predictors
c2=ncol(x)    #number of exposures
x1=data0$pred1
c1=ncol(x1)    #c1 is the number of original predictors
y=data0$y
y1=data0$y1
M1=data0$m2     #all mediators with binarized categories
M2=data0$m1     #all mediators with numbered categories
M3.1=data0$m3.1     #all mediators with continuous mediators-deltam/2
M3.2=data0$m3.2     #all mediators with continuous mediators+deltam/2
contm=data0$contm1  #all continuous mediators in M2
contm1=data0$contm2 #all continuous mediators in M1
deltam=data0$deltam
deltap=data0$deltap
p1=data0$p1         #number of continuous mediators
binm=data0$binm1    #all binary mediators in M2
binm1=data0$binm2   #all binary mediators in M1
p2=data0$p2         #number of binary mediators
p3=data0$p3         #number of categorical mediators
if(p3>0){
  cat1=max(data0$catm2[,2]-data0$catm2[,1]+1)  #largest number of categories of all categorical mediators-1
  cat2=data0$catm2[,2]-data0$catm2[,1]+2       #a vector of number of categories 
  catm=data0$catm1                             #all categorical mediators in M2
  catm1=data0$catm2}                           #all categorical mediators in M1
else{
  cat1=NULL
  cat2=NULL
  catm=NULL
  catm1=NULL
}
p=p1+p2+p3                 #number of mediators (categorical mediators are not binarized)
P=ncol(M1)           #number of mediators (including all binarized categorical mediator) P may not be p1+p2+p3
cova=data0$cova          
mcov=data0$mcov
mind=data0$mind
nmc=ifelse(is.null(mcov),0,ncol(mcov))
nc=ifelse(is.null(cova),0,ncol(cova))

if(y.type==3)
{caty=nlevels(as.factor(y))}

#if(y.type==4)
#{zero=rep(0,nrow(y))#is.cen=ifelse(y[,2]==1,0,1)   #censored or not
#if(is.null(tmax))
#  tmax=max(y[,1], na.rm=T)+100
#if(is.null(multi))
#  multi=TRUE}             #maximum time to event
#Cen=ifelse(y[,2]==1,tmax,y[,1])  #censoring time
#y=ifelse(y[,2]==1,y[,1],NA)}

#fit the models for the mediators
m.models=list()
deviances.m=list()

if(p1>0)
  for (i in 1:p1)
  {temp.x=cbind(x,mcov[,mind[contm[i],]])
  temp.y=M1[,contm1[i]]
  temp=!is.na(temp.y)
  set.seed(seed)
  m.models[[contm1[i]]]<-wbart(x.train=temp.x[temp,],y.train=temp.y[temp],
                               ntree=ntree, numcut=numcut, x.test=temp.x,       #parameters for trees of mediator
                               ndpost=ndpost, nskip=nskip, keepevery=keepevery,  #see ?wbart  
                               nkeeptrain=nkeeptrain, nkeeptest=nkeeptest,
                               nkeeptestmean=nkeeptestmean, nkeeptreedraws=nkeeptreedraws,
                               printevery=printevery)
  yhat.train=rbind(m.models[[contm1[i]]]$yhat.test.mean,m.models[[contm1[i]]]$yhat.test)
  sigma=c(mean(m.models[[contm1[i]]]$sigma),m.models[[contm1[i]]]$sigma)
  deviances.m[[contm[i]]]=apply(cbind(sigma,yhat.train), 1, function(yhat) {
    -2 * sum(dnorm(temp.y, mean = yhat[-1], sd = yhat[1], log = TRUE),na.rm=TRUE)})
  }

if(p2>0)
  for (i in 1:p2)
  {temp.x=cbind(x,mcov[,mind[binm[i],]])
  temp.y=M1[,binm1[i]]
  temp=!is.na(temp.y)
  set.seed(seed)
  m.models[[binm1[i]]]<-pbart(x.train=temp.x[temp,],y.train=temp.y[temp],
                              ntree=ntree, numcut=numcut, x.test=temp.x,       #parameters for trees of mediator
                              ndpost=ndpost, nskip=nskip, keepevery=keepevery,  #see ?wbart  
                              nkeeptrain=nkeeptrain, nkeeptest=nkeeptest,
                              nkeeptreedraws=nkeeptreedraws,
                              printevery=printevery)
  yhat.train <- rbind(m.models[[binm1[i]]]$prob.test.mean,m.models[[binm1[i]]]$prob.test)
  deviances.m[[binm[i]]] <- apply(yhat.train, 1, function(yhat) {
    -2 * sum(temp.y * log(yhat) + (1 - temp.y) * log(1 - yhat),na.rm=TRUE)
  })
  }

if(p3>0)
  for (i in 1:p3)
  {temp.x=cbind(x,mcov[,mind[catm[i],]])
  yhat.train=NULL
  for (j in catm1[i,1]:catm1[i,2])
  {temp.y=M1[,j]
  temp=!is.na(temp.y)
  set.seed(seed)
  m.models[[j]]<-pbart(x.train=temp.x[temp,],y.train=temp.y[temp],
                       ntree=ntree, numcut=numcut, x.test=temp.x,            #parameters for trees of mediator
                       ndpost=ndpost, nskip=nskip, keepevery=keepevery,  #see ?wbart  
                       nkeeptrain=nkeeptrain, nkeeptest=nkeeptest,
                       nkeeptreedraws=nkeeptreedraws,
                       printevery=printevery)
  yhat.train <- cbind(yhat.train,rbind(m.models[[j]]$prob.test.mean,m.models[[j]]$prob.test))
  }
  yhat.train1=apply(yhat.train,1,function(yhat){
    temp.1=matrix(yhat,cat2[i]-1,byrow=T)
    temp.2=apply(temp.1,2,function(temp.3){max(0.0001,1-sum(temp.3))})
    temp.4=rbind(temp.2,temp.1)
    return(as.vector(temp.4))})
  y.tt=as.numeric(M2[,catm[i]])
  deviances.m[[catm[i]]] <- apply(yhat.train1, 2, function(yhat) {
    -2 * sum(log(matrix(yhat,cat2[i])[cbind(y.tt,1:N)]),na.rm=TRUE)
  })
  }

#fit a model for the outcome
temp.x=cbind(x,M1,cova)
if(y.type==1)
{temp.y=y1
 temp=!is.na(temp.y)
 set.seed(seed)
 y.model=wbart(x.train=temp.x[temp,],y.train=temp.y[temp],
               ntree=ntree, numcut=numcut, x.test=temp.x,                    #parameters for trees of mediator
               ndpost=ndpost, nskip=nskip, keepevery=keepevery,  #see ?wbart  
               nkeeptrain=nkeeptrain, nkeeptest=nkeeptest,
               nkeeptestmean=nkeeptestmean, nkeeptreedraws=nkeeptreedraws,
               printevery=printevery)
 yhat.train=rbind(y.model$yhat.test.mean,y.model$yhat.test)
 sigma=c(mean(y.model$sigma),y.model$sigma)
 deviances.y=apply(cbind(sigma,yhat.train), 1, function(yhat) {
   -2 * sum(dnorm(temp.y, mean = yhat[-1], sd = yhat[1], log = TRUE),na.rm=TRUE)})
}
else if(y.type==2)
{temp.y=y1
 temp=!is.na(temp.y)
 set.seed(seed)
 y.model=pbart(x.train=temp.x[temp,],y.train=temp.y[temp],
               ntree=ntree, numcut=numcut, x.test=temp.x,                    #parameters for trees of mediator
               ndpost=ndpost, nskip=nskip, keepevery=keepevery,  #see ?wbart  
               nkeeptrain=nkeeptrain, nkeeptest=nkeeptest,
               nkeeptreedraws=nkeeptreedraws,
               printevery=printevery)
 yhat.train <- rbind(y.model$prob.test.mean,y.model$prob.test)
 deviances.y <- apply(yhat.train, 1, function(yhat) {
   -2 * sum(temp.y * log(yhat) + (1 - temp.y) * log(1 - yhat),na.rm=TRUE)
 })
}
else if(y.type==3)
 {temp.y=as.numeric(data0$y)
  temp=!is.na(temp.y)
  set.seed(seed)
  y.model=mbart(x.train=temp.x[temp,],y.train=temp.y[temp],
                      ntree=ntree, numcut=numcut, x.test=temp.x,             #parameters for trees of mediator
                      ndpost=ndpost, nskip=nskip, keepevery=keepevery,  #see ?wbart  
                      printevery=printevery)
  yhat.train <- rbind(y.model$prob.test.mean,y.model$prob.test)
  deviances.y <- apply(yhat.train, 1, function(yhat) {
    -2 * sum(log(matrix(yhat,caty)[cbind(temp.y,1:N)]),na.rm=TRUE)
  })
}
else{
  temp.y=y1
  temp=complete.cases(temp.y)
  train.temp=temp.x[temp,]
  times.temp=temp.y[temp,1]
  delta.temp=temp.y[temp,2]
  set.seed(seed)
  y.model=surv.bart(x.train=train.temp,times=times.temp,delta=delta.temp,x.test=temp.x,
                ntree=ntree, numcut=numcut,                       #parameters for trees of mediator
                ndpost=ndpost, nskip=nskip, keepevery=keepevery,  #see ?wbart  
                printevery=printevery)
  yhat.train <- rbind(y.model$prob.test.mean,y.model$surv.test)
  times.temp1=y.model$times
  ntime=length(times.temp1)
  times.temp=temp.y[,1]
  delta.temp=temp.y[,2]
  deviances.y <- apply(yhat.train, 1, function(yhat) {
    -2 * sum(delta.temp * log(matrix(yhat,ntime)[match(times.temp,times.temp1),1:N]) + (1 - delta.temp) * log(1 - matrix(yhat,ntime)[match(times.temp,times.temp1),1:N]))
  })
}

#check the results
#calculate the mediation effects
N1=ndpost/keepevery  #for mediators
#N2=(ndpost1-nskip1)/keepevery1  #for y

#m.mcov=apply(mcov,2,mean,na.rm=T)  #effects are calculated at the mean of mcov
#med0$BUGSoutput$sims.list$r=1/med0$BUGSoutput$sims.list$r
#attach(med0$BUGSoutput$sims.list)

if(y.type==3){
#contain results from method #2/1  
  aie2=array(0,c(N1,p,c2,caty-1))
  ie2=array(0,dim=c(N1,N,p,c2,caty-1))
  de2=array(0,dim=c(N1,N,c2,caty-1))
  ade2=array(0,c(N1,c2,caty-1)) #was the original de2
  
  te3=array(0,c(N1,N,c2,caty-1))
  ate3=array(0,c(N1,c2,caty-1))
  omu3=ate3
  ade3=ate3
  aie3=array(0,c(N1,p,c2,caty-1))
  ie3=array(0,dim=c(N1,N,p,c2,caty-1))
  de3=array(0,c(N1,N,c2,caty-1))
  ade3=array(0,dim=c(N1,c2,caty-1))
  mu_M2=M1                       #to store the E(M(x))
  mu_M3=mu_M2                    #to store the E(M(x+dx))
  
  te4=array(0,c(N1,N,caty-1))
  de4=te4
  ade4=array(0,c(N1,c2,caty-1))
  ie4=array(0,dim=c(N1,N,p,c2,caty-1))
  mu.M0=array(0,c(dim(M1),N1))
  mu.M1=mu.M0
  ate4=ade4
  omu4=ate4
  aie4=array(0,c(N1,p,c2,caty-1))
  
  for (l in 1:c2){ #for each predictor
    x1.temp=x
    x3.temp=x
    if(l%in%data0$contpred2){
      x1.temp[,l]=x[,l]-deltap[l]/2
      x3.temp[,l]=x[,l]+deltap[l]/2
    }
    else if(l%in%data0$binpred2)
    {x1.temp[,l]=0
    x3.temp[,l]=1
    deltap[l]=1}
    else{ #categorical predictor
      for (i in 1:nrow(data0$catpred2))
        if(l%in%(data0$catpred2[i,1]:data0$catpred2[i,2]))
        {x1.temp[,data0$catpred2[i,1]:data0$catpred2[i,2]]=0
         x3.temp[,data0$catpred2[i,1]:data0$catpred2[i,2]]=0
         x3.temp[,l]=1}
      deltap[l]=1
    }
    
#method2: the same for binary and continuous predictors
    temp.x=data.frame(matrix(0,N*2*ncol(M1),c2+P+nc))
    names(temp.x)=c(colnames(x),colnames(M1),colnames(cova))
    if(p1>0){
      for (j in 1:p1){
        temp.M3=M1
        temp.M1=M1
        temp.M3[,contm1[j]]=M3.2[,contm1[j]]
        temp.M1[,contm1[j]]=M3.1[,contm1[j]]
        temp.x[(2*N*contm1[j]-2*N+1):(2*N*contm1[j]-N),]=cbind(x,temp.M1,cova)
        temp.x[(2*N*contm1[j]-N+1):(2*N*contm1[j]),]=cbind(x,temp.M3,cova)}}
    
    if(p2>0){
      for (k in 1:p2){
        temp.M3=M1
        temp.M1=M1
        temp.M3[,binm1[k]]=1
        temp.M1[,binm1[k]]=0
        temp.x[(2*N*binm1[k]-2*N+1):(2*N*binm1[k]-N),]=cbind(x,temp.M1,cova)        
        temp.x[(2*N*binm1[k]-N+1):(2*N*binm1[k]),]=cbind(x,temp.M3,cova)}}        
    
    if(p3>0){
      for (j in 1:p3)
        for(k in catm1[j,1]:catm1[j,2])
        {M1.temp=M1
        M1.temp[,catm1[j,1]:catm1[j,2]]=0
        temp.M3=M1.temp
        temp.M1=M1.temp
        temp.M3[,k]=1
        temp.x[(2*N*k-2*N+1):(2*N*k-N),]=cbind(x,temp.M1,cova)
        temp.x[(2*N*k-N+1):(2*N*k),]=cbind(x,temp.M3,cova)}}
    
    temp.x=rbind(temp.x,cbind(x1.temp,M1,cova))
    temp.x=rbind(temp.x,cbind(x3.temp,M1,cova))
    
    y.temp=predict(y.model,newdata=temp.x)
    y.prob.test=list()
    ncol.temp=ncol(y.temp$prob.test)
    for(q1 in 2:caty)
      y.prob.test[[q1-1]]=y.temp$prob.test[,seq(q1,ncol.temp,by=caty)]
    
    apart.ie=array(0,c(N1,N,ncol(M1)))
    bpart.ie=array(0,c(N1,N,ncol(M1),(caty-1)))
    
    if(p1>0){
        for (j in 1:p1){
          temp.pred=predict(m.models[[contm1[j]]],newdata=rbind(cbind(x1.temp,mcov[,mind[contm[j],]]), cbind(x3.temp,mcov[,mind[contm[j],]])))
          mu_M3[,contm1[j]]=apply(temp.pred[,(N+1):(2*N)],2,mean,na.rm=T)
          mu_M2[,contm1[j]]=apply(temp.pred[,1:N],2,mean,na.rm=T)
          apart.ie[,,contm1[j]]=(temp.pred[,(N+1):(2*N)]-temp.pred[,1:N])/deltap[l]

          for(q1 in 2:caty)
          {temp.mu1=y.prob.test[[q1-1]][,(2*N*contm1[j]-2*N+1):(2*N*contm1[j]-N)]
           temp.mu3=y.prob.test[[q1-1]][,(2*N*contm1[j]-N+1):(2*N*contm1[j])]
           bpart.ie[,,contm1[j],q1-1]=(temp.mu3-temp.mu1)/deltam[contm[j]]
           ie2[,,contm[j],l,q1-1]=apart.ie[,,contm1[j]]*bpart.ie[,,contm1[j],q1-1]
           aie2[,contm[j],l,q1-1]=apply(ie2[,,contm[j],l,q1-1],1,mean,na.rm=T)}
        }}
    
    #for binary and categorical mediators, method 2 and method 1 are not the same
    if(p2>0){
        for (k in 1:p2){
          temp.pred=predict(m.models[[binm1[k]]],newdata=rbind(cbind(x1.temp,mcov[,mind[binm[k],]]), cbind(x3.temp,mcov[,mind[binm[k],]])))
          mu_M2[,binm1[k]]=rbinom(N,1,temp.pred$prob.test.mean[1:N])
          mu_M3[,binm1[k]]=rbinom(N,1,temp.pred$prob.test.mean[(N+1):(2*N)])
          apart.ie[,,binm1[k]]=(temp.pred$prob.test[,(N+1):(2*N)]-temp.pred$prob.test[,1:N])/deltap[l]

          for(q1 in 2:caty)
          {temp.mu1=y.prob.test[[q1-1]][,(2*N*binm1[k]-2*N+1):(2*N*binm1[k]-N)]
           temp.mu3=y.prob.test[[q1-1]][,(2*N*binm1[k]-N+1):(2*N*binm1[k])]
           bpart.ie[,,binm[k],q1-1]=(temp.mu3-temp.mu1)/deltam[binm[k]]
           ie2[,,binm[k],l,q1-1]=apart.ie[,,binm1[k]]*bpart.ie[,,binm[k],q1-1]
           aie2[,binm[k],l,q1-1]=apply(ie2[,,binm[k],l,q1-1],1,mean,na.rm=T)}
        }}

    if(p3>0){
      for (j in 1:p3){
        temp.mp2=matrix(0,N,cat2[j]-1)
        temp.mp3=matrix(0,N,cat2[j]-1)
        for (k in catm1[j,1]:catm1[j,2]){
          temp.pred=predict(m.models[[k]],newdata=rbind(cbind(x1.temp,mcov[,mind[catm[j],]]), cbind(x3.temp,mcov[,mind[catm[j],]])))
          temp.x3=predict(m.models[[k]],newdata=cbind(x3.temp,mcov[,mind[catm[j],]]))
          temp.mp2[,k-catm1[j,1]+1]=temp.pred$prob.test.mean[1:N]
          temp.mp3[,k-catm1[j,1]+1]=temp.pred$prob.test.mean[(N+1):(2*N)]
          apart.ie[,,k]=(temp.pred$prob.test[,(N+1):(2*N)]-temp.pred$prob.test[,1:N])/deltap[l]
        }
        #apart.ie[,,catm1[j,1]:catm1[j,2]]=apart
        temp.mp2=cbind(1-apply(temp.mp2,1,function(hat){min(0.999,sum(hat))}),temp.mp2)
        temp.mp3=cbind(1-apply(temp.mp3,1,function(hat){min(0.999,sum(hat))}),temp.mp3)
        for (i in 1:N)
        {mu_M2[i,catm1[j,1]:catm1[j,2]]=rmultinom(1,1,prob=temp.mp2[i,])[-1]
         mu_M3[i,catm1[j,1]:catm1[j,2]]=rmultinom(1,1,prob=temp.mp3[i,])[-1]} 
        
        for(q1 in 2:caty){
          for(k in catm1[j,1]:catm1[j,2])
          {temp.mu1=y.prob.test[[q1-1]][,(2*N*k-2*N+1):(2*N*k-N)]
           temp.mu3=y.prob.test[[q1-1]][,(2*N*k-N+1):(2*N*k)]
           bpart.ie[,,k,q1-1]=temp.mu3-temp.mu1
           ie2[,,catm[j],l,q1-1]=ie2[,,catm[j],l,q1-1]+ apart.ie[,,k]*bpart.ie[,,k,q1-1]
          }
          aie2[,catm[j],l,q1-1]<-apply(ie2[,,catm[j],l,q1-1],1,mean,na.rm=T)}
        }}
        
    #direct effect
    for(q1 in 2:caty)
    {temp.mu1=y.prob.test[[q1-1]][,(N*2*ncol(M1)+1):(N*2*ncol(M1)+N)]
     temp.mu3=y.prob.test[[q1-1]][,(N*2*ncol(M1)+N+1):(N*2*ncol(M1)+2*N)]
     de2[,,l,q1-1]=(temp.mu3-temp.mu1)/deltap[l]
     ade2[,l,q1-1]=apply(de2[,,l,q1-1],1,mean,na.rm=T)
     }  #ade2 was the original de2
    #total effect
    te2=apply(ie2,c(1,2,4,5),sum)+de2
    ate2=apply(aie2,c(1,3,4),sum)+ade2
    
#method 3:parametric
    #3.1. get M1(x) and M1(x+dx) for y
    #did this in method 2
    
    #3.2. get x and dx for y
    #did before method 2
    
    #3.3. create the new data for estimation
    j1=sample(1:N,size=N*(p+1),replace=T)
    newdata=rbind(cbind(x1.temp,mu_M2,cova),cbind(x3.temp,mu_M3,cova))
    newdata=do.call(rbind, replicate(p+2, newdata, simplify = FALSE))
    
    if(p1>0){
      for (j in 1:p1){
        newdata[(2*N*contm[j]-2*N+1):(2*N*contm[j]-N),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
        newdata[(2*N*contm[j]-N+1):(2*N*contm[j]),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
      }}
    if(p2>0){
      for (j in 1:p2){
        newdata[(2*N*binm[j]-2*N+1):(2*N*binm[j]-N),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
        newdata[(2*N*binm[j]-N+1):(2*N*binm[j]),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
      }}
    if(p3>0){
      for (j in 1:p3){
        newdata[(2*N*catm[j]-2*N+1):(2*N*catm[j]-N),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
        newdata[(2*N*catm[j]-N+1):(2*N*catm[j]),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
      }}
    newdata[(2*N*p+1):(2*N*p+N),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
    newdata[(2*N*p+1+N):(2*N*p+N*2),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
#    newdata=rbind(newdata,cbind(x1.temp,mu_M2,cova),cbind(x3.temp,mu_M3,cova))
    
   #3.4. estimation
    y.est2=predict(y.model,newdata = newdata) 
    tmp.ncol=ncol(y.est2$prob.test)
    
    for(q1 in 2:caty)
       {y.est1=y.est2$prob.test[,seq(q1,tmp.ncol,by=caty)]   
        mu_y=y.est1
        
        #3.4.1 get the total effect
        te3[,,l,q1-1]=(mu_y[,(2*N*(p+1)+1+N):(2*N*(p+1)+N*2)]-mu_y[,(2*N*(p+1)+1):(2*N*(p+1)+N)])/deltap[l]
        ate3[,l,q1-1]=apply(te3[,,l,q1-1],1,mean,na.rm=T)
    
       #3.4.2 calculate the ie
        for (j in 1:p){
         ie3[,,j,l,q1-1]=te3[,,l,q1-1]-(mu_y[,(2*N*j-N+1):(2*N*j)]-mu_y[,(2*N*j-2*N+1):(2*N*j-N)])/deltap[l]
         aie3[,j,l,q1-1]=apply(ie3[,,j,l,q1-1],1,mean,na.rm=T)}

       #3.4.3 Calculate the de
        de3[,,l,q1-1]=(mu_y[,(2*N*p+1+N):(2*N*p+N*2)]-mu_y[,(2*N*p+1):(2*N*p+N)])/deltap[l]
        ade3[,l,q1-1]=apply(de3[,,l,q1-1],1,mean,na.rm=T)
       }
   
#method 4: semi-parametric for binary or categorical predictors
    if(!l%in%data0$contpred2){
      #4.1. get M1(x) and M1(x+dx) for y
      x.i0=(1:N)[x[,l]==0]
      x.i1=(1:N)[x[,l]==1]
      i0=sample(x.i0,N,replace=T)
      i1=sample(x.i1,N,replace=T)
      mu_M2=M1[i0,]
      mu_M3=M1[i1,]
      
      #4.2. get x and dx for y
      #did before method 2
      
      #4.3. generate new data
      j1=sample(1:N,size=N*(p+1),replace=T)
      newdata=rbind(cbind(x1.temp,mu_M2,cova[i0,]),cbind(x3.temp,mu_M3,cova[i1,]))
      newdata=do.call(rbind, replicate(p+2, newdata, simplify = FALSE))
      
      if(p1>0){
        for (j in 1:p1){
          newdata[(2*N*contm[j]-2*N+1):(2*N*contm[j]-N),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
          newdata[(2*N*contm[j]-N+1):(2*N*contm[j]),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
        }}
      if(p2>0){
        for (j in 1:p2){
          newdata[(2*N*binm[j]-2*N+1):(2*N*binm[j]-N),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
          newdata[(2*N*binm[j]-N+1):(2*N*binm[j]),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
        }}
      if(p3>0){
        for (j in 1:p3){
          newdata[(2*N*catm[j]-2*N+1):(2*N*catm[j]-N),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
          newdata[(2*N*catm[j]-N+1):(2*N*catm[j]),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
        }}
      newdata[(2*N*p+1):(2*N*p+N),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
      newdata[(2*N*p+1+N):(2*N*p+N*2),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
#      newdata=rbind(newdata,cbind(x1.temp,mu_M2,cova[i0,]),cbind(x3.temp,mu_M3,cova[i1,]))
      
      #4.4. estimation
      y.est2=predict(y.model,newdata = newdata)
      tmp.ncol=ncol(y.est2$prob.test)
      
      for(q1 in 1:(caty-1))
       {y.est1=y.est2$prob.test[,seq(q1+1,tmp.ncol,seq=caty)]
        mu_y=y.est1
        #4.4.1 get the total effect
        te4[,,l,q1]=(mu_y[,(2*N*(p+1)+1+N):(2*N*(p+1)+N*2)]-mu_y[,(2*N*(p+1)+1):(2*N*(p+1)+N)])/deltap[l]
        ate4[,l,q1]=apply(te4[,,l,q1],1,mean,na.rm=T)
        
        #4.4.2 ie
        for (j in 1:p){
          ie4[,,j,l,q1]=te4[,,l,q1]-(mu_y[,(2*N*j-N+1):(2*N*j)]-mu_y[,(2*N*j-2*N+1):(2*N*j-N)])/deltap[l]
          aie4[,j,l,q1]=apply(ie4[,,j,l,q1],1,mean,na.rm=T)}
        
        #4.4.3 Calculate the de
        de4[,,l,q1]=(mu_y[,(2*N*p+1+N):(2*N*p+N*2)]-mu_y[,(2*N*p+1):(2*N*p+N)])/deltap[l]
        ade4[,l,q1]=apply(de4[,,l,q1],1,mean,na.rm=T)
      }
    }}
  
  colnames(aie4)=colnames(M2)
  colnames(aie2)=colnames(M2)
  colnames(aie3)=colnames(M2)
}
else{
  aie2=array(0,c(N1,p,c2))
  ie2=array(0,dim=c(N1,N,p,c2))
  de2=array(0,dim=c(N1,N,c2))
  ade2=array(0,c(N1,c2)) #was the original de2
  
  te3=array(0,dim=c(N1,N,c2))
  ate3=matrix(0,N1,c2)
  omu3=ate3
  de3=array(0,dim=c(N1,N,c2))
  ade3=matrix(0,N1,c2)
  aie3=array(0,c(N1,p,c2))
  ie3=array(0,dim=c(N1,N,p,c2))
  mu_M2=M1                       #to store the E(M(x))
  mu_M3=mu_M2                    #to store the E(M(x+dx))
  
  de4=array(0,dim=c(N1,N,c2))
  ade4=matrix(0,N1,c2)
  ie4=array(0,dim=c(N1,N,p,c2))
  mu.M0=array(0,c(dim(M1),N1))
  mu.M1=mu.M0
  te4=array(0,dim=c(N1,N,c2))
  ate4=matrix(0,N1,c2)
  omu4=ate4
  aie4=array(0,c(N1,p,c2))
  
  for (l in 1:c2){
    x1.temp=x
    x3.temp=x
    if(l%in%data0$contpred2){
      x1.temp[,l]=x[,l]-deltap[l]/2
      x3.temp[,l]=x[,l]+deltap[l]/2
    }
    else if(l%in%data0$binpred2)
    {x1.temp[,l]=0
    x3.temp[,l]=1
    deltap[l]=1}
    else{ #categorical predictor
      for (i in 1:nrow(data0$catpred2))
        if(l%in%(data0$catpred2[i,1]:data0$catpred2[i,2]))
        {x1.temp[,data0$catpred2[i,1]:data0$catpred2[i,2]]=0
        x3.temp[,data0$catpred2[i,1]:data0$catpred2[i,2]]=0
        x3.temp[,l]=1}
      deltap[l]=1
    }
    
    #method2: the same for binary and continuous predictors
    temp.x=data.frame(matrix(0,N*2*ncol(M1),c2+P+nc))
    names(temp.x)=c(colnames(x),colnames(M1),colnames(cova))
    
    if(p1>0){
      for (j in 1:p1){
        temp.M3=M1
        temp.M1=M1
        temp.M3[,contm1[j]]=M3.2[,contm1[j]]
        temp.M1[,contm1[j]]=M3.1[,contm1[j]]
        temp.x[(2*N*contm1[j]-2*N+1):(2*N*contm1[j]-N),]=cbind(x,temp.M1,cova)
        temp.x[(2*N*contm1[j]-N+1):(2*N*contm1[j]),]=cbind(x,temp.M3,cova)}}
    
    if(p2>0){
      for (k in 1:p2){
        temp.M3=M1
        temp.M1=M1
        temp.M3[,binm1[k]]=1
        temp.M1[,binm1[k]]=0
        temp.x[(2*N*binm1[k]-2*N+1):(2*N*binm1[k]-N),]=cbind(x,temp.M1,cova)        
        temp.x[(2*N*binm1[k]-N+1):(2*N*binm1[k]),]=cbind(x,temp.M3,cova)}}        

    if(p3>0){
      for (j in 1:p3)
        for(k in catm1[j,1]:catm1[j,2])
        {M1.temp=M1
         M1.temp[,catm1[j,1]:catm1[j,2]]=0
         temp.M3=M1.temp
         temp.M1=M1.temp
         temp.M3[,k]=1
         temp.x[(2*N*k-2*N+1):(2*N*k-N),]=cbind(x,temp.M1,cova)
         temp.x[(2*N*k-N+1):(2*N*k),]=cbind(x,temp.M3,cova)}}
    
    temp.x=rbind(temp.x,cbind(x1.temp,M1,cova))
    temp.x=rbind(temp.x,cbind(x3.temp,M1,cova))
    
    if(y.type==4)
      {pre=surv.pre.bart(x.train=train.temp,times=times.temp,delta=delta.temp,x.test=temp.x)
       y.temp=predict(y.model,newdata=pre$tx.test)
      }
    else
      y.temp=predict(y.model,newdata=temp.x)
    apart.ie=array(0,c(N1,N,ncol(M1)))
    bpart.ie=array(0,c(N1,N,ncol(M1)))
    
    if(p1>0){
      for (j in 1:p1){
        temp.pred=predict(m.models[[contm1[j]]],newdata=rbind(cbind(x1.temp,mcov[,mind[contm[j],]]), cbind(x3.temp,mcov[,mind[contm[j],]])))
        mu_M3[,contm1[j]]=apply(temp.pred[,(N+1):(2*N)],2,mean,na.rm=T)
        mu_M2[,contm1[j]]=apply(temp.pred[,1:N],2,mean,na.rm=T)
        apart.ie[,,contm1[j]]=(temp.pred[,(N+1):(2*N)]-temp.pred[,1:N])/deltap[l]
        
        if(y.type==1){
          temp.mu1=y.temp[,(2*N*contm1[j]-2*N+1):(2*N*contm1[j]-N)]
          temp.mu3=y.temp[,(2*N*contm1[j]-N+1):(2*N*contm1[j])]}
        else if (y.type==2){
          temp.mu1=y.temp$prob.test[,(2*N*contm1[j]-2*N+1):(2*N*contm1[j]-N)]
          temp.mu3=y.temp$prob.test[,(2*N*contm1[j]-N+1):(2*N*contm1[j])]}
        else if (y.type==4){
          temp.mu1=t(apply(y.temp$surv.test[,(2*N*contm1[j]*ntime-2*N*ntime+1):(2*N*contm1[j]*ntime-N*ntime)],1,median_survival_time,ntime,times.temp1))
          temp.mu3=t(apply(y.temp$surv.test[,(2*N*contm1[j]*ntime-N*ntime+1):(2*N*contm1[j]*ntime)],1,median_survival_time,ntime,times.temp1))}        
        bpart.ie[,,contm1[j]]=(temp.mu3-temp.mu1)/deltam[contm[j]]
        ie2[,,contm[j],l]=apart.ie[,,contm1[j]]*bpart.ie[,,contm1[j]]
        aie2[,contm[j],l]=apply(ie2[,,contm[j],l],1,mean,na.rm=T)
      }}
    
    #for binary and categorical mediators, method 2 and method 1 are not the same
    if(p2>0){
      for (k in 1:p2){
        temp.pred=predict(m.models[[binm1[k]]],newdata=rbind(cbind(x1.temp,mcov[,mind[binm[k],]]), cbind(x3.temp,mcov[,mind[binm[k],]])))
        mu_M2[,binm1[k]]=rbinom(N,1,temp.pred$prob.test.mean[1:N])
        mu_M3[,binm1[k]]=rbinom(N,1,temp.pred$prob.test.mean[(N+1):(2*N)])
        apart.ie[,,binm1[k]]=(temp.pred$prob.test[,(N+1):(2*N)]-temp.pred$prob.test[,1:N])/deltap[l]
        
        if(y.type==1)
        {temp.mu1=y.temp[,(2*N*binm1[k]-2*N+1):(2*N*binm1[k]-N)]
        temp.mu3=y.temp[,(2*N*binm1[k]-N+1):(2*N*binm1[k])]}
        else if (y.type==2)
        {temp.mu1=y.temp$prob.test[,(2*N*binm1[k]-2*N+1):(2*N*binm1[k]-N)]
        temp.mu3=y.temp$prob.test[,(2*N*binm1[k]-N+1):(2*N*binm1[k])]}
        else if (y.type==4)
        {temp.mu1=t(apply(y.temp$surv.test[,(2*N*binm1[k]*ntime-2*N*ntime+1):(2*N*binm1[k]*ntime-N*ntime)],1,median_survival_time,ntime,times.temp1))
        temp.mu3=t(apply(y.temp$surv.test[,(2*N*binm1[k]*ntime-N*ntime+1):(2*N*binm1[k]*ntime)],1,median_survival_time,ntime,times.temp1))}
        bpart.ie[,,binm[k]]=(temp.mu3-temp.mu1)/deltam[binm[k]]
        ie2[,,binm[k],l]=apart.ie[,,binm1[k]]*bpart.ie[,,binm[k]]
        aie2[,binm[k],l]=apply(ie2[,,binm[k],l],1,mean,na.rm=T)}
    }  
    
    if(p3>0){
      for (j in 1:p3){
        #     apart=array(0,c(N1,N,cat2[j]-1))
        temp.mp2=matrix(0,N,cat2[j]-1)
        temp.mp3=matrix(0,N,cat2[j]-1)
        for (k in catm1[j,1]:catm1[j,2]){
          temp.pred=predict(m.models[[k]],newdata=rbind(cbind(x1.temp,mcov[,mind[catm[j],]]), cbind(x3.temp,mcov[,mind[catm[j],]])))
          temp.x3=predict(m.models[[k]],newdata=cbind(x3.temp,mcov[,mind[catm[j],]]))
          temp.mp2[,k-catm1[j,1]+1]=temp.pred$prob.test.mean[1:N]
          temp.mp3[,k-catm1[j,1]+1]=temp.pred$prob.test.mean[(N+1):(2*N)]
          apart.ie[,,k]=(temp.pred$prob.test[,(N+1):(2*N)]-temp.pred$prob.test[,1:N])/deltap[l]
        } #[,,k-catm1[j,1]+1]
        temp.mp2=cbind(1-apply(temp.mp2,1,function(hat){min(0.999,sum(hat))}),temp.mp2)
        temp.mp3=cbind(1-apply(temp.mp3,1,function(hat){min(0.999,sum(hat))}),temp.mp3)
        for (i in 1:N)
        {mu_M2[i,catm1[j,1]:catm1[j,2]]=rmultinom(1,1,prob=temp.mp2[i,])[-1]
        mu_M3[i,catm1[j,1]:catm1[j,2]]=rmultinom(1,1,prob=temp.mp3[i,])[-1]}
        
        for(k in catm1[j,1]:catm1[j,2])
        {if(y.type==1)
        {temp.mu1=y.temp[,(2*N*k-2*N+1):(2*N*k-N)]
        temp.mu3=y.temp[,(2*N*k-N+1):(2*N*k)]}
          else if (y.type==2)
          {temp.mu1=y.temp$prob.test[,(2*N*k-2*N+1):(2*N*k-N)]
          temp.mu3=y.temp$prob.test[,(2*N*k-N+1):(2*N*k)]}
          else if (y.type==4)
          {temp.mu1=t(apply(y.temp$surv.test[,(2*N*k*ntime-2*N*ntime+1):(2*N*k*ntime-N*ntime)],1,median_survival_time,ntime,times.temp1))
           temp.mu3=t(apply(y.temp$surv.test[,(2*N*k*ntime-N*ntime+1):(2*N*k*ntime)],1,median_survival_time,ntime,times.temp1))}
          
          bpart.ie[,,k]=temp.mu3-temp.mu1
          ie2[,,catm[j],l]=ie2[,,catm[j],l]+apart.ie[,,k]*bpart.ie[,,k]
        }
        aie2[,catm[j],l]<-apply(ie2[,,catm[j],l],1,mean,na.rm=T)
      }}
    
 #direct effect
    if (y.type==2){
      temp.mu1=y.temp$prob.test[,(N*2*ncol(M1)+1):(N*2*ncol(M1)+N)]
      temp.mu3=y.temp$prob.test[,(N*2*ncol(M1)+N+1):(N*2*ncol(M1)+2*N)]}
    else if (y.type==1){
      temp.mu1=y.temp[,(N*2*ncol(M1)+1):(N*2*ncol(M1)+N)]
      temp.mu3=y.temp[,(N*2*ncol(M1)+N+1):(N*2*ncol(M1)+2*N)]}
    else { 
      temp.mu1=t(apply(y.temp$surv.test[,(N*2*ncol(M1)*ntime+1):(N*2*ncol(M1)*ntime+N*ntime)],1,median_survival_time,ntime,times.temp1))
      temp.mu3=t(apply(y.temp$surv.test[,(N*2*ncol(M1)*ntime+N*ntime+1):(N*2*ncol(M1)*ntime+2*N*ntime)],1,median_survival_time,ntime,times.temp1))
    }    #for the time-to-event
    de2[,,l]=(temp.mu3-temp.mu1)/deltap[l]
    ade2[,l]=apply(de2[,,l],1,mean,na.rm=T)

 #total effect
    te2=apply(ie2,c(1,2,4),sum)+de2
    ate2=apply(aie2,c(1,3),sum)+ade2
    #method 3:parametric
    #3.1. get M1(x) and M1(x+dx) for y
    #did this in method 2

    #3.2. get x and dx for y
    #did before method 2
    
    #3.3. create the new data for estimation
    j1=sample(1:N,size=N*(p+1),replace=T)
    newdata=rbind(cbind(x1.temp,mu_M2,cova),cbind(x3.temp,mu_M3,cova))
    newdata=do.call(rbind, replicate(p+2, newdata, simplify = FALSE))
    
    if(p1>0){
      for (j in 1:p1){
        newdata[(2*N*contm[j]-2*N+1):(2*N*contm[j]-N),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
        newdata[(2*N*contm[j]-N+1):(2*N*contm[j]),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
      }}
    if(p2>0){
      for (j in 1:p2){
        newdata[(2*N*binm[j]-2*N+1):(2*N*binm[j]-N),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
        newdata[(2*N*binm[j]-N+1):(2*N*binm[j]),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
      }}
    if(p3>0){
      for (j in 1:p3){
        newdata[(2*N*catm[j]-2*N+1):(2*N*catm[j]-N),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
        newdata[(2*N*catm[j]-N+1):(2*N*catm[j]),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
      }}
    newdata[(2*N*p+1):(2*N*p+N),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
    newdata[(2*N*p+1+N):(2*N*p+N*2),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
#    newdata=rbind(newdata,cbind(x1.temp,mu_M2,cova),cbind(x3.temp,mu_M3,cova))
    
    #3.4. estimation
    if(y.type==4)
      {pre=surv.pre.bart(x.train=train.temp,times=times.temp,delta=delta.temp,x.test=newdata)
       y.est1=predict(y.model,newdata=pre$tx.test)}
    else
       y.est1=predict(y.model,newdata = newdata)

    if(y.type==1)
      mu_y=y.est1
    else if(y.type==2)
      mu_y=y.est1$prob.test
    else 
      mu_y=t(apply(y.est1$surv.test,1,median_survival_time,ntime,times.temp1))
    
    #3.4.1 get the total effect
    te3[,,l]=(mu_y[,(2*N*(p+1)+1+N):(2*N*(p+1)+N*2)]-mu_y[,(2*N*(p+1)+1):(2*N*(p+1)+N)])/deltap[l]
    ate3[,l]=apply(te3[,,l],1,mean,na.rm=T)
    
    #3.4.2 ie
    for (j in 1:p){
      ie3[,,j,l]=te3[,,l]-(mu_y[,(2*N*j-N+1):(2*N*j)]-mu_y[,(2*N*j-2*N+1):(2*N*j-N)])/deltap[l]
      aie3[,j,l]=apply(ie3[,,j,l],1,mean,na.rm=T)}
    #3.4.3 Calculate the de
    de3[,,l]=(mu_y[,(2*N*p+1+N):(2*N*p+N*2)]-mu_y[,(2*N*p+1):(2*N*p+N)])/deltap[l]
    ade3[,l]=apply(de3[,,l],1,mean,na.rm=T)
    
    #method4: semi-parametric for binary or categorical predictors
    if(!l%in%data0$contpred2){
      #4.1. get M1(x) and M1(x+dx) for y
      x.i0=(1:N)[x[,l]==0]
      x.i1=(1:N)[x[,l]==1]
      i0=sample(x.i0,N,replace=T)
      i1=sample(x.i1,N,replace=T)
      mu_M2=M1[i0,]
      mu_M3=M1[i1,]
      
      #4.2. get x and dx for y
      #did before method 2
      
      #4.3. generate new data
      j1=sample(1:N,size=N*(p+1),replace=T)
      newdata=rbind(cbind(x1.temp,mu_M2,cova[i0,]),cbind(x3.temp,mu_M3,cova[i1,]))
      newdata=do.call(rbind, replicate(p+2, newdata, simplify = FALSE))
      
      if(p1>0){
        for (j in 1:p1){
          newdata[(2*N*contm[j]-2*N+1):(2*N*contm[j]-N),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
          newdata[(2*N*contm[j]-N+1):(2*N*contm[j]),c2+contm1[j]]=M1[j1[(N*contm[j]-N+1):(N*contm[j])],contm1[j]]
        }}
      if(p2>0){
        for (j in 1:p2){
          newdata[(2*N*binm[j]-2*N+1):(2*N*binm[j]-N),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
          newdata[(2*N*binm[j]-N+1):(2*N*binm[j]),c2+binm1[j]]=M1[j1[(N*binm[j]-N+1):(N*binm[j])],binm1[j]]
        }}
      if(p3>0){
        for (j in 1:p3){
          newdata[(2*N*catm[j]-2*N+1):(2*N*catm[j]-N),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
          newdata[(2*N*catm[j]-N+1):(2*N*catm[j]),(c2+catm1[j,1]):(c2+catm1[j,2])]=M1[j1[(N*catm[j]-N+1):(N*catm[j])],catm1[j,1]:catm1[j,2]]
        }}
      newdata[(2*N*p+1):(2*N*p+N),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
      newdata[(2*N*p+1+N):(2*N*p+N*2),(c2+1):(c2+P)]=M1[j1[(N*p+1):(N*p+N)],]
#      newdata=rbind(newdata,cbind(x1.temp,mu_M2,cova[i0,]),cbind(x3.temp,mu_M3,cova[i1,]))
      
      #4.4. estimation
      if(y.type==4)
       {pre=surv.pre.bart(x.train=train.temp,times=times.temp,delta=delta.temp,x.test=newdata)
        y.est1=predict(y.model,newdata=pre$tx.test)
      }
      else
        y.est1=predict(y.model,newdata = newdata)
      
      if(y.type==1)
        mu_y=y.est1
      else if(y.type==2)
        mu_y=y.est1$prob.test
      else 
        mu_y=t(apply(y.est1$surv.test,1,median_survival_time,ntime,times.temp1))
      
      #4.4.1 get the total effect
      te4[,,l]=(mu_y[,(2*N*(p+1)+1+N):(2*N*(p+1)+N*2)]-mu_y[,(2*N*(p+1)+1):(2*N*(p+1)+N)])/deltap[l]
      ate4[,l]=apply(te4[,,l],1,mean,na.rm=T)
      #4.4.2 ie
      for (j in 1:p){
        ie4[,,j,l]=te4[,,l]-(mu_y[,(2*N*j-N+1):(2*N*j)]-mu_y[,(2*N*j-2*N+1):(2*N*j-N)])/deltap[l]
        aie4[,j,l]=apply(ie4[,,j,l],1,mean,na.rm=T)}
      #4.4.3 Calculate the de
      de4[,,l]=(mu_y[,(2*N*p+1+N):(2*N*p+N*2)]-mu_y[,(2*N*p+1):(2*N*p+N)])/deltap[l]
      ade4[,l]=apply(de4[,,l],1,mean,na.rm=T)
    }
  }
  
  colnames(aie4)=colnames(M2)
  colnames(aie2)=colnames(M2)
  colnames(aie3)=colnames(M2)
}
#detach(med0$BUGSoutput$sims.list)

# Calculate the deviance for y and m
deviances=deviances.y
for (i in 1:p)
  deviances=deviances+deviances.m[[i]]

# Posterior mean of the deviance
D_bar <- mean(deviances[-1])

# Variance of the deviance
var_D <- var(deviances[-1])

# Effective number of parameters
p_D <- c(0.5 * var_D,D_bar-deviances[1])

# Calculate DIC
DIC <- D_bar + 2*p_D[2]

result=list(aie2=aie2,ade2=ade2,ate2=ate2,ie2=ie2,de2=de2,te2=te2,apart.ie=apart.ie,bpart.ie=bpart.ie,
            aie3=aie3,ade3=ade3,ate3=ate3,ie3=ie3,de3=de3,te3=te3,
            aie4=aie4,ade4=ade4,ate4=ate4,ie4=ie4,de4=de4,te4=te4,
            data0=data0,y.type=y.type,y.model=y.model,m.models=m.models,
            DIC=list(deviances.m=deviances.m,deviances.y=deviances.y,deviances=deviances,D_bar=D_bar,var_D=var_D,p_D=p_D,DIC=DIC)) #ie2=ie2, med0$BUGSoutput$sims.list
class(result)='bma.bart'
return(result)
}

summary.bma.bart<-function(object, ..., plot= TRUE, RE=TRUE, quant=c(0.025, 0.25, 0.5, 0.75,0.975),digit=4,method=3,trim=0.05)
{
  summary.med<-function(vec,qua=quant, digit=digit)
  {c(mean=mean(vec,na.rm=T),sd=sd(vec,na.rm=T),quantile(vec,qua,na.rm=T))
  }
  
  summary.med.re<-function(vec,vec1,qua=quant, digit=digit)
  {vec=vec/vec1
  c(mean=mean(vec,na.rm=T),sd=sd(vec,na.rm=T),quantile(vec,qua,na.rm=T))}
  
  N=object$data0$N
  trim1=floor(N*trim)
  if(trim1>0)
    trim.order=c(1:trim1,(N-trim1+1):N)
  else trim.order=NA
  
  if(!any(is.na(trim.order))){
    c2=ncol(object$ade2)
    x=object$data0$pred2
    p=object$data0$nm
    if(object$data0$y_type==3){
      caty=nlevels(as.factor(object$data0$y))
     for (l in 1:c2){ #for each predictor
      if(l%in%object$data0$contpred2){
        sel=!(order(x[,l])%in%trim.order)
        
        for(q1 in 2:caty)
        {for (j in 1:p)
        {object$aie2[,j,l,q1-1]=apply(object$ie2[,sel,j,l,q1-1],1,mean,na.rm=T)
         object$aie3[,j,l,q1-1]=apply(object$ie3[,sel,j,l,q1-1],1,mean,na.rm=T)
         }
         object$ade2[,l,q1-1]=apply(object$de2[,sel,l,q1-1],1,mean,na.rm=T)
         object$ade3[,l,q1-1]=apply(object$de3[,sel,l,q1-1],1,mean,na.rm=T)
         object$ate3[,l,q1-1]=apply(object$te3[,sel,l,q1-1],1,mean,na.rm=T)
        }
      }  
    }        
    object$ate2=apply(object$aie2,c(1,3,4),sum)+object$ade2 #method 4 is only for categorical predictor
}
  else{
    for (l in 1:c2){ #for each predictor
      if(l%in%object$data0$contpred2){
        sel=!(order(x[,l])%in%trim.order)
      for (j in 1:p)
        {object$aie2[,j,l]=apply(object$ie2[,sel,j,l],1,mean,na.rm=T)
         object$aie3[,j,l]=apply(object$ie3[,sel,j,l],1,mean,na.rm=T)}
         object$ade2[,l]=apply(object$de2[,sel,l],1,mean,na.rm=T)
         object$ade3[,l]=apply(object$de3[,sel,l],1,mean,na.rm=T)
         object$ate3[,l]=apply(object$te3[,sel,l],1,mean,na.rm=T) #method 4 is only for categorical predictor
      }  
    } 
    object$ate2=apply(object$aie2,c(1,3),sum)+object$ade2
}}
  
  if(object$data0$y_type!=3){
    result2<-array(0,c(7,2+ncol(object$aie2),ncol(object$ade2)))
    result2.re<-array(0,c(7,1+ncol(object$aie2),ncol(object$ade2)))
    result3<-result2
    result3.re<-result2.re
    result4<-result2
    result4.re<-result2.re
    for(j in 1:ncol(object$ade2)){
      result2[,,j]<-apply(cbind(TE=object$ate2[,j],DE=object$ade2[,j],object$aie2[,,j]),2,summary.med)
      result2.re[,,j]<-apply(cbind(DE=object$ade2[,j],object$aie2[,,j]),2,summary.med.re,object$ate2[,j])
      
      result3[,,j]<-apply(cbind(TE=object$ate3[,j],DE=object$ade3[,j],object$aie3[,,j]),2,summary.med)
      result3.re[,,j]<-apply(cbind(DE=object$ade3[,j],object$aie3[,,j]),2,summary.med.re,object$ate3[,j])
      
      result4[,,j]<-apply(cbind(TE=object$ate4[,j],DE=object$ade4[,j],object$aie4[,,j]),2,summary.med)
      result4.re[,,j]<-apply(cbind(DE=object$ade4[,j],object$aie4[,,j]),2,summary.med.re,object$ate4[,j])}}
  else{
    result2<-array(0,c(7,2+ncol(object$aie2),ncol(object$ade2),dim(object$ade2)[3]))
    result2.re<-array(0,c(7,1+ncol(object$aie2),ncol(object$ade2),dim(object$ade2)[3]))
    result3<-result2
    result3.re<-result2.re
    result4<-result2
    result4.re<-result2.re
    for(j in 1:ncol(object$ade2)){
      for(q1 in 1:dim(object$ade2)[3]){
        result2[,,j,q1]<-apply(cbind(TE=object$ate2[,j,q1],DE=object$ade2[,j,q1],object$aie2[,,j,q1]),2,summary.med)
        result2.re[,,j,q1]<-apply(cbind(DE=object$ade2[,j,q1],object$aie2[,,j,q1]),2,summary.med.re,object$ate2[,j,q1])
        
        result3[,,j,q1]<-apply(cbind(TE=object$ate3[,j,q1],DE=object$ade3[,j,q1],object$aie3[,,j,q1]),2,summary.med)
        result3.re[,,j,q1]<-apply(cbind(DE=object$ade3[,j,q1],object$aie3[,,j,q1]),2,summary.med.re,object$ate3[,j,q1])
        
        result4[,,j,q1]<-apply(cbind(TE=object$ate4[,j,q1],DE=object$ade4[,j,q1],object$aie4[,,j,q1]),2,summary.med)
        result4.re[,,j,q1]<-apply(cbind(DE=object$ade4[,j,q1],object$aie4[,,j,q1]),2,summary.med.re,object$ate4[,j,q1])}
    }
  }
  c.names=colnames(object$aie2)
  colnames(result2)=c("TE","DE",c.names)
  colnames(result3)=c("TE","DE",c.names)
  colnames(result4)=c("TE","DE",c.names)
  colnames(result2.re)=c("DE",c.names)
  colnames(result3.re)=c("DE",c.names)
  colnames(result4.re)=c("DE",c.names)
  rownames(result2)=c("mean","sd",paste("q",quant,sep="_"))
  rownames(result3)=c("mean","sd",paste("q",quant,sep="_"))
  rownames(result4)=c("mean","sd",paste("q",quant,sep="_"))
  rownames(result2.re)=c("mean","sd",paste("q",quant,sep="_"))
  rownames(result3.re)=c("mean","sd",paste("q",quant,sep="_"))
  rownames(result4.re)=c("mean","sd",paste("q",quant,sep="_"))
  
  result=list(result2=result2,result2.re=result2.re,result3=result3,result3.re=result3.re,
              result4=result4,result4.re=result4.re,method=method,
              digit=digit,plot=plot,RE=RE,y.type=object$data0$y_type,tmax=object$tmax)
  class(result)="summary.bma.bart"
  result
}

print.summary.bma.bart<-function (x, ..., digit = x$digit, method=x$method, RE=x$RE)
{plot.sum<-function(obj1,main1="Estimated Effects")
{oldpar <- par(no.readonly = TRUE)
on.exit(par(oldpar))
re <- obj1[1,]
upper <- obj1[7,]
lower <- obj1[3,]
name1 <- colnames(obj1)
par(mfrow = c(1, 1), mar = c(1, 6, 1, 1), oma = c(3, 2, 2, 4))
bp <- barplot2(re, horiz = TRUE, main = main1,
               names.arg = name1, plot.ci = TRUE, ci.u = upper,
               ci.l = lower, cex.names = 0.9, beside = FALSE,
               cex.axis = 0.9, las = 1, xlim = range(c(upper,lower), na.rm = TRUE,finite=T),
               col = rainbow(length(re), start = 3/6, end = 4/6))}
if(x$y.type!=3){
  for (j in 1:dim(x$result2)[3])
  {message('\nFor Predictor', j, '\n')
   if(method==2){
      if(!RE)
      {message('Estimated Effects for Method 2:\n')
        print(round(x$result2[,,j],digits = digit))
        if(x$plot)
          plot.sum(x$result2[,,j],main1=paste("Estimated Effects Using Method ", method, " (predictor ",j,")",sep=""))}
      else{
        message('Estimated Relative Effects for Method 2:\n')
        print(round(x$result2.re[,,j],digits = digit))
        if(x$plot)
          plot.sum(x$result2.re[,,j],main1=paste("Estimated Relative Effects Using Method ", method, " (predictor ",j,")",sep=""))}
    }
    else if(method==3){
      if(!RE)
      {message('Estimated Effects for Method 3:\n')
        print(round(x$result3[,,j],digits = digit))
        if(x$plot)
          plot.sum(x$result3[,,j],main1=paste("Estimated Effects Using Method ", method, " (predictor ",j,")",sep=""))}
      else{
        message('Estimated Relative Effects for Method 3:\n')
        print(round(x$result3.re[,,j],digits = digit))
        if(x$plot)
          plot.sum(x$result3.re[,,j],main1=paste("Estimated Relative Effects Using Method ", method, " (predictor ",j,")",sep=""))}
    }
    else if(method==4){
      if(!RE)
      {message('Estimated Effects for Method 4:\n')
        print(round(x$result4[,,j],digits = digit))
        if(x$plot)
          plot.sum(x$result4[,,j],main1=paste("Estimated Effects Using Method ", method, " (predictor ",j,")",sep=""))}
      else{
        message('Estimated Relative Effects for Method 4:\n')
        print(round(x$result4.re[,,j],digits = digit))
        if(x$plot)
          plot.sum(x$result4.re[,,j],main1=paste("Estimated Relative Effects Using Method ", method, " (predictor ",j,")",sep=""))}
    }
  }}
else{
  for (j in 1:dim(x$result2)[3])
    for (q1 in 1:dim(x$result2)[4])
    {message('\nFor Predictor', j, 'outcome',q1, ':\n')
     if(method==2){
        if(!RE)
        {message('Estimated Effects for Method 2:\n')
          print(round(x$result2[,,j,q1],digits = digit))
          if(x$plot)
            plot.sum(x$result2[,,j,q1],main1=paste("Estimated Effects Using Method ", method, " (predictor ",j,"outcome",q1,")",sep=""))}
        else{
          message('Estimated Relative Effects for Method 2:\n')
          print(round(x$result2.re[,,j,q1],digits = digit))
          if(x$plot)
            plot.sum(x$result2.re[,,j,q1],main1=paste("Estimated Relative Effects Using Method ", method, " (predictor ",j,"outcome",q1,")",sep=""))}
      }
      else if(method==3){
        if(!RE)
        {message('Estimated Effects for Method 3:\n')
          print(round(x$result3[,,j,q1],digits = digit))
          if(x$plot)
            plot.sum(x$result3[,,j,q1],main1=paste("Estimated Effects Using Method ", method, " (predictor ",j,"outcome",q1,")",sep=""))}
        else{
          message('Estimated Relative Effects for Method 3:\n')
          print(round(x$result3.re[,,j,q1],digits = digit))
          if(x$plot)
            plot.sum(x$result3.re[,,j,q1],main1=paste("Estimated Relative Effects Using Method ", method, " (predictor ",j,"outcome",q1,")",sep=""))}
      }
      else if(method==4){
        if(!RE)
        {message('Estimated Effects for Method 4:\n')
          print(round(x$result4[,,j,q1],digits = digit))
          if(x$plot)
            plot.sum(x$result4[,,j,q1],main1=paste("Estimated Effects Using Method ", method, " (predictor ",j,"outcome",q1,")",sep=""))}
        else{
          message('Estimated Relative Effects for Method 4:\n')
          print(round(x$result4.re[,,j,q1],digits = digit))
          if(x$plot)
            plot.sum(x$result4.re[,,j,q1],main1=paste("Estimated Relative Effects Using Method ", method, " (predictor ",j,"outcome",q1,")",sep=""))}
      }
    }
}
}






