% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-model.R
\name{configure_model}
\alias{configure_model}
\title{Generic S3 method for configuring the model to be fit by brms}
\usage{
configure_model(model, data, formula)
}
\arguments{
\item{model}{A model list object returned from check_model()}

\item{data}{The user supplied data.frame containing the data to be checked}

\item{formula}{The user supplied formula}
}
\value{
A named list containing at minimum the following elements:
\itemize{
\item formula: An object of class \code{brmsformula}. The constructed model formula
\item data: the user supplied data.frame, preprocessed by check_data
\item family: the brms family object
\item prior: the brms prior object
\item stanvars: (optional) An object of class \code{stanvars} (for custom families).
See \code{\link[brms:custom_family]{brms::custom_family()}} for more details.
}
}
\description{
Called by bmm() to automatically construct the model
formula, family objects and default priors for the model specified by the
user. It will call the appropriate configure_model.* functions based on the
list of classes defined in the .model_* functions. Currently, we have a
method only for the last class listed in the .model_* functions. This is to
keep model configuration as simple as possible. In the future we may add
shared methods for classes of models that share the same configuration.
}
\details{
A bare bones configure_model.* method should look like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{configure_model.newmodel <- function(model, data, formula) \{

   # preprocessing - e.g. extract arguments from data check, construct new variables
   <preprocessing code>

   # construct the formula
   formula <- bmf2bf(formula, model)

   # construct the family
   family <- <code for new family>

   # construct the default prior
   prior <- <code for new prior>

   # return the list
   nlist(formula, data, family, prior)
\}
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
configure_model.mixture3p <- function(model, data, formula) {
  # retrieve arguments from the data check
  max_set_size <- attr(data, "max_set_size")
  lure_idx <- attr(data, "lure_idx_vars")
  nt_features <- model$other_vars$nt_features
  set_size_var <- model$other_vars$set_size

  # construct initial brms formula
  formula <- bmf2bf(model, formula) +
    brms::lf(kappa2 ~ 1) +
    brms::lf(mu2 ~ 1) +
    brms::nlf(theta1 ~ thetat) +
    brms::nlf(kappa1 ~ kappa)

  # additional internal terms for the mixture model formula
  kappa_nts <- paste0("kappa", 3:(max_set_size + 1))
  theta_nts <- paste0("theta", 3:(max_set_size + 1))
  mu_nts <- paste0("mu", 3:(max_set_size + 1))

  for (i in 1:(max_set_size - 1)) {
    formula <- formula +
      glue_nlf("{kappa_nts[i]} ~ kappa") +
      glue_nlf(
        "{theta_nts[i]} ~ {lure_idx[i]} * (thetant + log(inv_ss)) + ",
        "(1 - {lure_idx[i]}) * (-100)"
      ) +
      glue_nlf("{mu_nts[i]} ~ {nt_features[i]}")
  }

  # define mixture family
  vm_list <- lapply(1:(max_set_size + 1), function(x) brms::von_mises(link = "identity"))
  vm_list$order <- "none"
  formula$family <- brms::do_call(brms::mixture, vm_list)

  nlist(formula, data)
}
\dontshow{\}) # examplesIf}
}
\keyword{developer}
\keyword{internal}
