#' greencredit Bayesian Network
#'
#' The coupling relationships and influence mechanisms of green credit and energy-environment-economy under China's goal of carbon neutrality.
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network nvestigate the coupling relationships and influence mechanisms of green credit and 3E system. Probabilities were given within the referenced paper (missing distributions were set as uniform). The vertices are:
#' \describe{
#'  \item{ECS}{Energy consumption structure (High, Medium, Low);}
#'  \item{EI}{Energy intensity (High, Medium, Low);}
#'  \item{EPI}{Environment (High, Medium, Low);}
#'  \item{GCI}{Interest expense proportion (High, Medium, Low);}
#'  \item{GDP}{Economy sharing (High, Medium, Low);}
#'  \item{IS}{Green economy (High, Medium, Low);}
#'  \item{OU}{Economy opening up (High, Medium, Low);}
#'  \item{PEC}{Per capita energy consumption (High, Medium, Low);}
#'  \item{TP}{Economy innovation (High, Medium, Low);}
#'  \item{UR}{Economy coordination (High, Medium, Low);}
#'  }
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @keywords NULL
#' @importClassesFrom bnlearn bn.fit
#' @references Chai, J., Wang, Y., Hu, Y., Zhang, X., & Zhang, X. (2023). The Coupling Relationships and Influence Mechanisms of Green Credit and Energy-Environment-Economy Under China's Goal of Carbon Neutrality. Journal of Systems Science and Complexity, 36(1), 360-374.
"greencredit"
