% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{db_secrets_list}
\alias{db_secrets_list}
\title{List Secrets in Secret Scope}
\usage{
db_secrets_list(
  scope,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{scope}{Name of the scope whose secrets you want to list}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
List Secrets in Secret Scope
}
\details{
This is a metadata-only operation; you cannot retrieve secret data using this
API. You must have \code{READ} permission to make this call.

The \code{last_updated_timestamp} returned is in milliseconds since epoch.
\itemize{
\item Throws \code{RESOURCE_DOES_NOT_EXIST} if no such secret scope exists.
\item Throws \code{PERMISSION_DENIED} if you do not have permission to make this API
call.
}
}
\seealso{
Other Secrets API: 
\code{\link{db_secrets_delete}()},
\code{\link{db_secrets_put}()},
\code{\link{db_secrets_scope_acl_delete}()},
\code{\link{db_secrets_scope_acl_get}()},
\code{\link{db_secrets_scope_acl_list}()},
\code{\link{db_secrets_scope_acl_put}()},
\code{\link{db_secrets_scope_create}()},
\code{\link{db_secrets_scope_delete}()},
\code{\link{db_secrets_scope_list_all}()}
}
\concept{Secrets API}
