% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_mkdirs}
\alias{db_dbfs_mkdirs}
\title{DBFS mkdirs}
\usage{
db_dbfs_mkdirs(
  path,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{The path of the new file. The path should be the absolute DBFS
path (for example \verb{/mnt/my-file.txt}).}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Create the given directory and necessary parent directories if they do not
exist.
}
\details{
\itemize{
\item If there exists a file (not a directory) at any prefix of the input path,
this call throws an exception with \code{RESOURCE_ALREADY_EXISTS.}
\item If this operation fails it may have succeeded in creating some of the
necessary parent directories.
}
}
\seealso{
Other DBFS API: 
\code{\link{db_dbfs_add_block}()},
\code{\link{db_dbfs_close}()},
\code{\link{db_dbfs_create}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_list}()},
\code{\link{db_dbfs_move}()},
\code{\link{db_dbfs_put}()},
\code{\link{db_dbfs_read}()}
}
\concept{DBFS API}
