% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-query-execution.R
\name{db_sql_exec_cancel}
\alias{db_sql_exec_cancel}
\title{Cancel SQL Query}
\usage{
db_sql_exec_cancel(
  statement_id,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{statement_id}{String, query execution \code{statement_id}}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Cancel SQL Query
}
\details{
Requests that an executing statement be canceled. Callers must poll for
status to see the terminal state.

\href{https://docs.databricks.com/api/workspace/statementexecution/cancelexecution}{Read more on Databricks API docs}
}
\seealso{
Other SQL Execution APIs: 
\code{\link{db_sql_exec_query}()},
\code{\link{db_sql_exec_result}()},
\code{\link{db_sql_exec_status}()}
}
\concept{SQL Execution APIs}
