% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Table}
\alias{bs4Table}
\alias{bs4TableItems}
\alias{bs4TableItem}
\title{Boostrap 4 table container}
\usage{
bs4Table(data, cardWrap = FALSE, bordered = FALSE, striped = FALSE, width = 12)

bs4TableItems(...)

bs4TableItem(..., dataCell = FALSE)
}
\arguments{
\item{data}{Expect dataframe, tibble or list of shiny tags... See examples.}

\item{cardWrap}{Whether to wrap the table in a card. FALSE by default.}

\item{bordered}{Whether to display border between elements. FALSE by default.}

\item{striped}{Whether to displayed striped in elements. FALSE by default.}

\item{width}{Table width. 12 by default.}

\item{...}{Any HTML element.}

\item{dataCell}{Whether the cell should be contain data or text. <td> by default.}
}
\description{
Build an Bootstrap 4 table container

Build an bs4 table item row

Build an bs4 table item
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 # width dataframe as input
 shinyApp(
  ui = dashboardPage(
    header = dashboardHeader(), 
    sidebar = dashboardSidebar(),
    body = dashboardBody(
     bs4Table(
      cardWrap = TRUE,
      bordered = TRUE,
      striped = TRUE,
      iris
     )
    ), 
    footer = dashboardFooter()
  ),
  server = function(input, output) { }
 )
 
 # with shiny tags as input
 shinyApp(
  ui = dashboardPage(
    header = dashboardHeader(), 
    sidebar = dashboardSidebar(),
    body = dashboardBody(
      bs4Table(
        cardWrap = TRUE,
        bordered = TRUE,
        striped = TRUE,
        list(
          list(
            income = "$2,500 USD", 
            status = dashboardBadge(
              "Pending",
              position = "right",
              color = "danger",
              rounded = TRUE
            ), 
            progress = progressBar(value = 50, status = "pink", size = "xxs"), 
            text = "test", 
            confirm = actionButton(
              "go",
              "Go"
            )
          ),
          list("$2,500 USD", "NA", "NA", "test", "NA")
        )
      )
    ), 
    footer = dashboardFooter()
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\keyword{internal}
