% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.thresPPP.R
\name{cv.thresPPP}
\alias{cv.thresPPP}
\title{CV for Bayesian Estimation of a Sparse Covariance Matrix}
\usage{
cv.thresPPP(
  X,
  thresvec,
  epsvec,
  prior = NULL,
  thresfun = "hard",
  nsample = 2000,
  ncores = 2
)
}
\arguments{
\item{X}{a n \eqn{\times} p data matrix with column mean zero.}

\item{thresvec}{a vector of real numbers specifying the parameter of the threshold function.}

\item{epsvec}{a vector of small positive numbers decreasing to \eqn{0}.}

\item{prior}{a list giving the prior information.
The list includes the following parameters (with default values in parentheses):
\code{A (I)} giving the positive definite scale matrix for the inverse-Wishart prior,
\code{nu (p + k)} giving the degree of freedom of the inverse-Wishar prior.}

\item{thresfun}{a string to specify the type of threshold function. \code{fun ('hard')} giving the thresholding function ('hard' or 'soft') for the thresholding PPP procedure.}

\item{nsample}{a scalar value giving the number of the post-processed posterior samples.}

\item{ncores}{a scalar value giving the number of CPU cores.}
}
\value{
\item{CVdf}{a M \eqn{\times} 3 dataframe having the estimated spectral norm error for each thres and eps, where M = length(thresvec) * length(epsvec)}
}
\description{
Performs cross-validation to estimate spectral norm error for a post-processed posterior of a sparse covariance matrix.
}
\details{
Given a set of train data and validation data, the spectral norm error for each \eqn{\gamma} and \eqn{\epsilon_n} is estimated as follows:
 \deqn{
 ||\hat{\Sigma}(\gamma,\epsilon_n)^{(train)} - S^{(val)}||_2
 }
where \eqn{\hat{\Sigma}(\gamma,\epsilon_n)^{(train)}} is the estimate for the covariance based on the train data and \eqn{S^{(val)}} is the sample covariance matrix based on the validation data.
The spectral norm error is estimated by the \eqn{10}-fold cross-validation.
For more details, see the first paragraph on page 9 in Lee and Lee (2023).
}
\examples{

\donttest{
Sigma0 <- diag(1,50)
X <- mvtnorm::rmvnorm(25,sigma = Sigma0)
thresvec <- c(0.01,0.1)
epsvec <- c(0.01,0.1)
res <- bspcov::cv.thresPPP(X,thresvec,epsvec,nsample=100)
plot(res)}
\dontshow{
# R CMD check: make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")) future::plan(future::sequential)
}

}
\references{
Lee, K. and Lee, J. (2023), "Post-processes posteriors for sparse covariances", \emph{Journal of Econometrics}, 236(3), 105475.
}
\seealso{
thresPPP
}
\author{
Kwangmin Lee
}
\keyword{covariance}
\keyword{sparse}
