% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart.R
\name{axe-bart}
\alias{axe-bart}
\alias{axe_call.bart}
\alias{axe_fitted.bart}
\title{Axing a bart model.}
\usage{
\method{axe_call}{bart}(x, verbose = FALSE, ...)

\method{axe_fitted}{bart}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed bart object.
}
\description{
Axing a bart model.
}
\examples{
\dontshow{if (rlang::is_installed("dbarts")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dbarts)
x <- dbarts::bart(mtcars[,2:5], mtcars[,1], verbose = FALSE, keeptrees = TRUE)
res <- butcher(x, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
