% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_functions.R
\name{model_information}
\alias{model_information}
\alias{supported_models}
\alias{supported_timed_models}
\alias{supported_optimizers}
\alias{supported_families}
\alias{supported_plots}
\alias{get_model}
\alias{model_parameters}
\alias{model_outputs}
\title{Model information functions}
\usage{
supported_models()

supported_timed_models()

supported_optimizers()

supported_families()

supported_plots(model = NULL)

get_model(model)

model_parameters(model = NULL)

model_outputs(model = NULL)
}
\arguments{
\item{model}{A string specifying a model. One from \code{supported_models()}.}
}
\value{
\code{supported_models()} returns a character vector.

\code{supported_timed_models()} returns a character vector.

\code{supported_optimizers()} returns a character vector.

\code{supported_families()} returns a character vector.

\code{supported_plots()} returns a character vector or list
(if model is NULL).

\code{get_model()} returns a model function.

\code{model_parameters()} returns a list or a
list of lists (if model is NULL).

\code{model_outputs()} returns a character vector or
list (if model is NULL).
}
\description{
An assortment of functions to return model information.
}
\examples{
# Outputs and plots supported by the RW1972 model
model_outputs("RW1972")

# Getting the model function implementing the PKH1982 model
pkh_func <- get_model("PKH1982")
head(pkh_func, 10)

# Getting the parameters required by SM2007
model_parameters("SM2007")
}
