% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replication_settings.R
\name{AutoReplicationSettings}
\alias{AutoReplicationSettings}
\title{Create auto replication settings.}
\usage{
AutoReplicationSettings(
  wishart = FALSE,
  odf = NA,
  sdf = NA,
  checkMinMax = TRUE,
  checkPosDef = FALSE,
  quiet = NA
)
}
\arguments{
\item{wishart}{logical, sample OMEGAs and SIGMAs from scaled inverse chi-squared (univariate OMEGA distribution)
or Wishart distribution (block of OMEGAs)}

\item{odf}{the degrees of freedom for the scaled inverse chi-squared/Wishart distribution with regards to the OMEGAs}

\item{sdf}{the degrees of freedom for the scaled inverse chi-squared/Wishart distribution with regards to the SIGMAs}

\item{checkMinMax}{logical, check for min/max values when sampling the parameters, default is TRUE}

\item{checkPosDef}{logical, check for positive definiteness when sampling the OMEGA/SIGMA parameters from the variance-covariance matrix (i.e. when \code{wishart=FALSE}), default is FALSE (requires extra time)}

\item{quiet}{logical, suppress info messages, default is NA. By default, messages will be printed out when the success rate of sampling the parameters is below 95\%.}
}
\value{
replication settings
}
\description{
By default, all model parameters are sampled from a multivariate normal 
distribution, whose characteristics are specified by the variance-covariance matrix.
OMEGAs and SIGMAs can be sampled from scaled inverse chi-squared or Wishart distributions
by setting the \code{wishart} argument to \code{TRUE}. In that case, THETAs are still sampled
from a multivariate normal distribution, while OMEGAS and SIGMAs are sampled from
scaled inverse chi-squared (univariate OMEGA/SIGMA distribution) and Wishart (block of
OMEGAs/SIGMAs) distribution, respectively. When \code{wishart} is set to \code{TRUE}, the degrees
of freedom of the distribution must be specified, respectively, \code{odf} for the OMEGAs and
\code{sdf} for the SIGMAs.
}
