% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_continuous_ci.R
\name{ard_continuous_ci}
\alias{ard_continuous_ci}
\alias{ard_continuous_ci.data.frame}
\title{ARD continuous CIs}
\usage{
ard_continuous_ci(data, ...)

\method{ard_continuous_ci}{data.frame}(
  data,
  variables,
  by = dplyr::group_vars(data),
  conf.level = 0.95,
  method = c("t.test", "wilcox.test"),
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame. See below for details.}

\item{...}{arguments passed to \code{t.test()} or \code{wilcox.test()}}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent t-tests will be computed for
each variable.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
optional column name to compare by.}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}

\item{method}{(\code{string})\cr
a string indicating the method to use for the confidence interval
calculation. Must be one of \code{"t.test"} or \code{"wilcox.test"}}
}
\value{
ARD data frame
}
\description{
One-sample confidence intervals for continuous variable means and medians.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ard_continuous_ci(mtcars, variables = c(mpg, hp), method = "wilcox.test")
ard_continuous_ci(mtcars, variables = mpg, by = am, method = "t.test")
\dontshow{\}) # examplesIf}
}
