% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare predictions and labels}
\usage{
compare(
  predictions,
  labels,
  partition = TRUE,
  names = c(specificity = 0, sensitivity = 1)
)
}
\arguments{
\item{predictions}{integer, predicted class}

\item{labels}{integer, true class state (reference standard)}

\item{partition}{logical, should result be split into one matrix per class (TRUE; default) or not (FALSE)}

\item{names}{integer (named), values give data values, names give class names}
}
\value{
data matrix with values 1 (correct prediction) and 0 (false prediction)
}
\description{
Compare predictions and labels
}
\examples{
pred <- matrix(c(1,1,0), 5, 3)
labels <- c(1, 1, 0, 0, 1)
compare(pred, labels, FALSE)
compare(pred, labels, TRUE)
}
