% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices.R
\name{cbc_choices}
\alias{cbc_choices}
\title{Simulate choices for a survey design}
\usage{
cbc_choices(design, priors = NULL)
}
\arguments{
\item{design}{A \code{cbc_design} object created by \code{cbc_design()}}

\item{priors}{A \code{cbc_priors} object created by \code{cbc_priors()}, or \code{NULL}
(default) for random choices.}
}
\value{
Returns the input design with an additional \code{choice} column
identifying the simulated choices.
}
\description{
Simulate choices for a survey design, either randomly or according to a
utility model defined by user-provided prior parameters. When priors are
provided, choices are simulated using the same probability computation
framework as used in cbc_design() for consistency.
}
\examples{
library(cbcTools)

# Create profiles and design
profiles <- cbc_profiles(
  price = c(1, 2, 3),
  type = c("A", "B", "C"),
  quality = c("Low", "High")
)

design <- cbc_design(
  profiles = profiles,
  n_alts = 2,
  n_q = 4
)

# Simulate random choices (default)
choices_random <- cbc_choices(design)

# Create priors and simulate utility-based choices
priors <- cbc_priors(
  profiles = profiles,
  price = -0.1,
  type = c(0.5, 0.2),  # vs reference level
  quality = 0.3
)

choices_utility <- cbc_choices(design, priors = priors)
}
