% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbsopendata.R
\docType{package}
\name{cbsodataR-package}
\alias{cbsodataR}
\alias{cbsodataR-package}
\title{Download all data from Statistics Netherlands / CBS}
\description{
\code{cbsodataR} allows to download all official statistics of Statistics
Netherlands (CBS) into R. For a introduction please visit the
\href{https://edwindj.github.io/cbsodataR/articles/cbsodataR.html}{vignette}:
\code{vignette("cbsodataR", package="cbsodataR")}. For an introduction on using
cbs cartographic maps: \code{vignette("maps", package="cbsodataR")}
The functions \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}
and \code{\link[=cbs_get_data]{cbs_get_data()}} should get you going.
Interested in cartographic maps, see \code{\link[=cbs_get_maps]{cbs_get_maps()}}.
}
\section{Catalog function}{

\itemize{
\item \code{\link[=cbs_get_datasets]{cbs_get_datasets()}} returns a data.frame with table of contents (toc): the publication
meta data for available tables, can also include the extra tables not directly available
in StatLine (dataderden)
\item \code{\link[=cbs_get_catalogs]{cbs_get_catalogs()}}, returns data.frame with the available (extra) catalogs.
\item \code{\link[=cbs_get_toc]{cbs_get_toc()}}, returns a data.frame with table of contents (toc): the publication
meta data for available tables within the standard CBS
\item \code{\link[=cbs_search]{cbs_search()}}, returns a data.frame with tables that contain the given
search word.
}
}

\section{Data retrieval}{

\itemize{
\item \code{\link[=cbs_get_data]{cbs_get_data()}}, returns the data of a specific opendata/StatLine table
\item \code{\link[=cbs_download_table]{cbs_download_table()}}, saves the data (and metadata) as csv files
into a directory
}
}

\section{Meta data}{

\itemize{
\item \code{\link[=cbs_get_meta]{cbs_get_meta()}}, returns the meta data objects of a specific opendata / StatLine
table .
\item \code{\link[=cbs_add_date_column]{cbs_add_date_column()}}, converts date/period codes into \code{DateTime} objects
in the data set that was downloaded.
\item \code{\link[=cbs_add_label_columns]{cbs_add_label_columns()}}, adds labels to the code columns in the data that
was downloaded.
}
}

\section{Cartographic maps}{

\itemize{
\item \code{\link[=cbs_get_maps]{cbs_get_maps()}}, returns a data.frame with available CBS maps
\item \code{\link[=cbs_join_sf_with_data]{cbs_join_sf_with_data()}}, returns an sf object joined with cbs table
\item \code{\link[=cbs_get_sf]{cbs_get_sf()}}, returns an sf object without data, e.g. "gemeente_2020".
}
}

\section{Copyright use}{

The content of CBS opendata is subject to Creative Commons Attribution (CC BY 4.0).
This means that the re-use of the content is permitted, provided Statistics
Netherlands is cited as the source. For more information see:
\url{https://www.cbs.nl/en-gb/about-us/website/copyright}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/edwindj/cbsodataR}
  \item Report bugs at \url{https://github.com/edwindj/cbsodataR/issues}
}

}
\author{
\strong{Maintainer}: Edwin de Jonge \email{edwindjonge@gmail.com}

Other contributors:
\itemize{
  \item Sara Houweling [contributor]
}

}
