% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDINA2GDINA.R
\name{RDINA2GDINA}
\alias{RDINA2GDINA}
\title{Translate RDINA object into GDINA object}
\usage{
RDINA2GDINA(fit)
}
\arguments{
\item{fit}{An object of class \code{RDINA}.}
}
\value{
\code{RDINA2GDINA} returns an object of class \code{GDINA}. See the \code{GDINA} package for more information.
}
\description{
This function translates an object of class \code{RDINA} to an object of class \code{GDINA}, so that the estimated R-DINA object is compatible with most of the functions in the \code{GDINA} package (Ma & de la Torre, 2020), including model fit, item fit, and Q-matrix validation.
}
\examples{
\donttest{
library(GDINA)
dat <- sim30DINA$simdat
Q <- sim30DINA$simQ
fit1 <- RDINA(dat, Q)
fit2 <- RDINA2GDINA(fit1)
modelfit(fit2) # Model fit evaluation
itemfit(fit2) # Item fit evaluation
}
}
\references{
Ma, W., & de la Torre, J. (2020). GDINA: An R package for cognitive diagnosis modeling. \emph{Journal of Statistical Software}, \emph{93}(14). https://doi.org/10.18637/jss.v093.i14
}
\author{
{Pablo Nájera, Universidad Pontificia Comillas}
}
