% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specificity_plot.R
\name{specificity_plot}
\alias{specificity_plot}
\alias{specificity_plotly}
\title{Specificity plot}
\usage{
specificity_plot(
  mk,
  subclass = NULL,
  group = NULL,
  type = 1,
  use_filter = FALSE,
  nrank = 8,
  nsubclass = NULL,
  expfilter = NULL,
  scheme = NULL,
  add_labels = NULL,
  label_pos = "right",
  axis_extend = 0.4,
  nudge_x = NULL,
  nudge_y = NULL,
  ...
)

specificity_plotly(
  mk,
  subclass = NULL,
  group = NULL,
  type = 1,
  use_filter = FALSE,
  nrank = 8,
  nsubclass = NULL,
  expfilter = NULL,
  scheme = NULL,
  ...
)
}
\arguments{
\item{mk}{a 'cellMarkers' class object.}

\item{subclass}{character value specifying the subclass to be plotted.}

\item{group}{character value specifying cell group to be plotted. One of
\code{subclass} or \code{group} must be specified.}

\item{type}{Numeric value, either 1 (the default) for a plot of angle on x
axis and mean expression on y axis; or 2 for a plot projecting the vector
angle into the same plain. See Details below.}

\item{use_filter}{logical, whether to use gene mean expression to which
noise reduction filtering has been applied.}

\item{nrank}{number of ranks of subclasses to display.}

\item{nsubclass}{numeric value, number of top markers to label. By default
this is obtained from \code{mk} for that subclass.}

\item{expfilter}{numeric value for the expression filter level below which
genes are excluded from being markers. Defaults to the level used when
\code{cellMarkers()} or \code{updateMarkers()} was called.}

\item{scheme}{Vector of colours for points.}

\item{add_labels}{character vector of additional genes to label}

\item{label_pos}{character value, either "left" or "right" specifying which
side to add labels. Only for \code{type = 1} plots.}

\item{axis_extend}{numeric value, specifying how far to extend the x axis to
the left as a proportion. Only invoked when \code{label_pos = "left"}.}

\item{nudge_x, nudge_y}{Label adjustments passed to \code{geom_label_repel()} or
\code{geom_text_repel()}.}

\item{...}{Optional arguments passed to \code{geom_label_repel()} or
\code{geom_text_repel()} for \code{specificity_plot()} or \code{plot_ly()} for
\code{specificity_plotly()}.}
}
\value{
ggplot2 or plotly scatter plot object.
}
\description{
Scatter plot showing specificity of genes as markers for a particular cell
subclass. Optimal gene markers for that cell subclass are those genes which
are closest to or lie on the y axis, while also being of highest mean
expression.
}
\details{
For \code{type = 1}, coordinates are drawn as x = angle of vector in degrees, y =
mean gene expression of each gene in the subclass of interest. This version
is easier to use to identify additional gene markers. The plotly version
allows users to hover over points and identify which gene they belong to.

If \code{type = 2}, the coordinates are drawn as x = vector length * sin(angle)
and y = vector length * cos(angle), where vector length is the Euclidean
length of that gene in space where each cell subclass is a dimension. Angle
is the angle between the projected vector in space against perfection for
that cell subclass, i.e. the vector lying perfectly along the subclass
dimension with no deviation along other subclass dimensions, i.e. a gene
which is expressed solely in that subclass and has 0 expression in all other
subclasses. y is equal to the mean expression of each gene in the subclass of
interest. x represents the Euclidean distance of mean expression in all other
subclasses, i.e. overall non-specific gene expression in other subclasses.
Thus, the plot represents a rotation of all genes as vectors around the axis
of the subclass of interest onto the same plane so that the angle with the
subclass of interest is visualised between genes.

Colour is used to overlay the ranking of each gene across the subclasses,
showing for each gene where the subclass of interest is ranked compared to
the other subclasses. Best markers have the subclass of interest ranked 1st.
}
