% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/median_center.R
\name{median_center}
\alias{median_center}
\title{Median Center}
\usage{
median_center(x, group = NULL, weight = NULL, tolerance = 1e-04)
}
\arguments{
\item{x}{Input POINT, MULTIPOINT, POLYGON, or MULTIPOLYGON
simple features}

\item{group}{name of character column specifying groups
to calculate individual median centers for}

\item{weight}{name of numeric weight column specifying an
individual point's contribution to the median center}

\item{tolerance}{numeric threshold determining when an
estimate improvement is sufficiently small enough to stop
iterating (smaller = slower, but more precision)}
}
\value{
An sf object with a median center for each group
}
\description{
Median center iteratively calculates the point that minimizes
distance to all features. One can specify the groups to calculate
individual centers for and weights for each individual point. It
is analagous to the \href{https://pro.arcgis.com/en/pro-app/latest/tool-reference/spatial-statistics/median-center.htm}{ArcGIS Pro Median Center}
tool.

It uses the methodology introduced by Kuhn and Kuenne (1962).

Currently, median center is only implemenented for projected data.
}
\examples{
df <- data.frame(
  lon = c(-88, -90, -92, -89, -90),
  lat = c(42, 40, 30, 32, 42),
  grp = c("a", "b", "a", "b", "a"),
  wt = c(1, 1, 1, 1, 1)
)
x <- sf::st_as_sf(df, coords = c("lon", "lat"), crs = 4326)
x_transformed <- sf::st_transform(x, crs = "ESRI:102003")
median_center(x_transformed, group = "grp", weight = "wt")
}
