% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.chandwich}
\alias{vcov.chandwich}
\title{Calculate the variance-covariance model for an object of class "chandwich"}
\usage{
\method{vcov}{chandwich}(object, complete = FALSE, adjusted = TRUE, ...)
}
\arguments{
\item{object}{an object of class "chandwich", a result of a call to
\code{\link{adjust_loglik}}.}

\item{complete}{A logical scalar.  If \code{complete = TRUE} then the
  full variance-covariance matrix is returned, including any fixed
  using \code{fixed_pars} and \code{fixed_at} in the call to
  \code{\link{adjust_loglik}}.  In this instance the corresponding
  elements of the matrix are \code{NA}. Otherwise, the variance-covariance
  matrix of only the free parameters is returned.

  The default is \code{complete = FALSE}, which is in sync with
  \code{\link{coef.chandwich}}.}

\item{adjusted}{A logical scalar.  If \code{adjusted = TRUE} then the
variance-covariance matrix is estimated using a sandwich estimator.
Otherwise, the inverse of the observed information at the MLE is used.}

\item{...}{Additional optional arguments. At present no optional
arguments are used.}
}
\value{
A numeric matrix.  The dimensions will be named if names were
  provided in the call to \code{\link{adjust_loglik}}.
}
\description{
\code{vcov} method for class "chandwich".
}
\details{
The variance-covariance matrix is based on
\code{attributes(object)$adjVC} for \code{adjusted = TRUE} and
\code{attributes(object)$VC} for \code{adjusted = FALSE}.
These return the estimate variance-covariance matrix of only the
free parameters.
}
\seealso{
\code{\link{coef.chandwich}}: \code{coef} method for
  class "chandwich".

\code{\link{summary.chandwich}}: \code{summary} method for
  class "chandwich".

\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood.
}
