% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclideanPath.R
\name{plot.euclidean_path}
\alias{plot.euclidean_path}
\title{Plot the path of the Euclidean distance between cases and/or pumps.}
\usage{
\method{plot}{euclidean_path}(x, zoom = 0.5, unit.posts = "distance",
  unit.interval = NULL, ...)
}
\arguments{
\item{x}{An object of class "euclidean_path" created by euclideanPath().}

\item{zoom}{Logical or Numeric. A numeric value >= 0 controls the degree of zoom. The default is 0.5.}

\item{unit.posts}{Character. "distance" for mileposts; "time" for timeposts; \code{NULL} for no posts.}

\item{unit.interval}{Numeric. Set interval between posts. When \code{unit.posts} is "distance", \code{unit.interval} automatically defaults to 50 meters. When \code{unit.posts} is "time", \code{unit.interval} automatically defaults to 60 seconds.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R plot.
}
\description{
Plot the path of the Euclidean distance between cases and/or pumps.
}
\examples{
plot(euclideanPath(15))
plot(euclideanPath(15), unit.posts = "time")
}
