% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{parseSets}
\alias{parseSets}
\title{Obtain an internal representation of CIfly sets.}
\usage{
parseSets(sets, ruletable, tableAsString = FALSE)
}
\arguments{
\item{sets}{A list mapping set names to a list of elements.}

\item{ruletable}{Path to a ruletable file.}

\item{tableAsString}{Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.}
}
\value{
Internal CIfly sets representation.
}
\description{
Obtain an internal representation of CIfly sets. Advanced usage only, mostly recommended for improving performance if the same sets are used multiple times. The parsed sets object can be passed to all methods with a sets argument. It is compatible with all ruletables that have the same \verb{SETS ...} line as the ruletable passed as argument.
}
\examples{
dsepTable <- "
    EDGES --> <--
    SETS X, Z
    START <-- AT X
    OUTPUT ...
    --> | <-- | current in Z
    ... | ... | current not in Z
"
sets <- list("X" = c(1), "Z" = c(4))

s <- parseSets(sets, dsepTable, tableAsString=TRUE)
edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))
reach(edgelist, s, dsepTable, tableAsString=TRUE)
}
