% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct.R
\name{correct}
\alias{correct}
\title{Scoring correct/incorrect answers}
\usage{
correct(x, key, navalue = NA)
}
\arguments{
\item{x}{a data frame or matrix.}

\item{key}{a vector indicating the keys to score the data.}

\item{navalue}{a single value indicating the score of NAs.}
}
\value{
A data frame with 1s for correct answers and 0s for incorrect answers.
}
\description{
Transforms a data frame or matrix with raw answers into
a data frame with 1s (correct answers) and 0s (incorrect answers).
}
\examples{
data(dichodata)
data(dichokey)

# NAs as NAs
head(dichodata)
ex1 <- correct(x = dichodata, key = dichokey, navalue = NA)
head(ex1)

# NAs as 0s
head(dichodata)
ex2 <- correct(x = dichodata, key = dichokey, navalue = 0)
head(ex2)


}
