% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterOptimization.r
\name{fitMarkovChains}
\alias{fitMarkovChains}
\title{Generates a list of markov chains from a given set of clusters}
\usage{
fitMarkovChains(clusters, order = 1)
}
\arguments{
\item{clusters}{The clusters from which to generate markov chain objects.}

\item{order}{The order for the markov chain.}
}
\description{
The purpose of this function is to generate pre-computed markov chain objects from clusters of clickstreams.
}
\examples{

training <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
              "User2,i,c,i,c,c,c,d",
              "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
              "User4,c,c,p,c,d")

test <- c("User1,h,c,c,p,p,h,c,p,p,c,p,p,o",
          "User2,i,c,i,c,c,c,d",
          "User4,c,c,c,c,d")

trainingCLS <- as.clickstreams(training, header = TRUE)
testCLS <- as.clickstreams(test, header = TRUE)

clusters <- clusterClickstreams(trainingCLS, centers = 2)
markovchains <- fitMarkovChains(clusters, order = 1)
}
\author{
Theo van Kraay \email{theo.vankraay@hotmail.com}
}
