% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs_get_augmented_data.R
\name{cs_get_augmented_data}
\alias{cs_get_augmented_data}
\alias{cs_get_augmented_data.default}
\alias{cs_get_augmented_data.cs_distribution}
\alias{cs_get_augmented_data.cs_statistical}
\alias{cs_get_augmented_data.cs_combined}
\alias{cs_get_augmented_data.cs_percentage}
\alias{cs_get_augmented_data.cs_anchor_individual_within}
\title{Extract Augmented Data from a cs_analysis Object}
\usage{
cs_get_augmented_data(x, ...)

\method{cs_get_augmented_data}{default}(x, ...)

\method{cs_get_augmented_data}{cs_distribution}(x, ...)

\method{cs_get_augmented_data}{cs_statistical}(x, ...)

\method{cs_get_augmented_data}{cs_combined}(x, ...)

\method{cs_get_augmented_data}{cs_percentage}(x, ...)

\method{cs_get_augmented_data}{cs_anchor_individual_within}(x, ...)
}
\arguments{
\item{x}{A \code{cs_analysis} object}

\item{...}{Additional arguments}
}
\value{
A tibble with augmented data
}
\description{
This function returns the patient-wise results, containing the considered pre
and post intervention value, its raw change as well as all other change
estimates calculated during the clinical significance analysis with the
individual's clinical significance category. This function is only useful for
individual level analyses because the group level analyses only yield group
level results.
}
\examples{
# Augmented data can be extracted for every individual approach
anchor_results <- claus_2020 |>
  cs_anchor(
    id,
    time,
    bdi,
    pre = 1,
    post = 4,
    mid_improvement = 9
  )


distribution_results <- claus_2020 |>
  cs_distribution(
    id,
    time,
    bdi,
    pre = 1,
    post = 4,
    reliability = 0.80
  )


distribution_results_hlm <- claus_2020 |>
  cs_distribution(
    id,
    time,
    bdi,
    rci_method = "HLM"
  )


statistical_results <- claus_2020 |>
  cs_statistical(
    id,
    time,
    bdi,
    pre = 1,
    post = 4,
    m_functional = 8,
    sd_functional = 8
  )


combined_results <- claus_2020 |>
  cs_combined(
    id,
    time,
    bdi,
    pre = 1,
    post = 4,
    m_functional = 8,
    sd_functional = 8,
    reliability = 0.80
  )


cs_get_augmented_data(anchor_results)
cs_get_augmented_data(distribution_results)
cs_get_augmented_data(distribution_results_hlm)
cs_get_augmented_data(statistical_results)
cs_get_augmented_data(combined_results)
}
\seealso{
Extractor functions
\code{\link{cs_get_data}()},
\code{\link{cs_get_model}()},
\code{\link{cs_get_n}()},
\code{\link{cs_get_reliability}()},
\code{\link{cs_get_summary}()}
}
\concept{get}
