% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_scan.R
\name{grid_scan}
\alias{grid_scan}
\title{Running model on a grid of parameters/initial states}
\usage{
grid_scan(
  model_gen,
  grid,
  apply.fn = identity,
  n.core = 2,
  custom.export = NULL,
  ...
)
}
\arguments{
\item{model_gen}{Odin model generator, see \code{getOdinGen()}.}

\item{grid}{Data frame of the parameter grid.}

\item{apply.fn}{Function to apply before return (e.g., some summary).}

\item{n.core}{Number of cores for parallel computing.}

\item{custom.export}{Names of additional variables used by apply.fn.}

\item{...}{Model \verb{$run(...)} parameters.}
}
\value{
List of model run results.
}
\description{
This function is useful for running a large scan of parameter combinations
for the same model. Typical use cases are probing stability of an attractor,
effect of certain parameters on the system, etc.
}
\details{
Grid is a data frame whose columns are model parameters.
See \code{model$contents()} for tunable parameters.
}
\examples{
vignette("grid-scan", "clockSim")
}
