% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_env.R
\name{create_env}
\alias{create_env}
\title{Create a Conda Environment}
\usage{
create_env(
  packages = NULL,
  env_file = NULL,
  env_name = "condathis-env",
  channels = c("bioconda", "conda-forge"),
  method = c("native", "auto"),
  additional_channels = NULL,
  platform = NULL,
  verbose = "silent",
  overwrite = FALSE
)
}
\arguments{
\item{packages}{Character vector. Names of the packages, and
version strings if necessary, e.g. 'python=3.11'. The use of the \code{packages}
argument assumes that env_file is not used.}

\item{env_file}{Character. Path to the YAML file with Conda Environment
description. If this argument is used, the \code{packages} argument should not
be included in the command.}

\item{env_name}{Character. Name of the Conda environment where the packages
are going to be installed. Defaults to 'condathis-env'.}

\item{channels}{Character vector. Names of the channels to be included.
By default 'c("bioconda", "conda-forge")' are used for solving
dependencies.}

\item{method}{Character. Beckend method to run \code{micromamba}, the default is
"auto" running "native" with the \code{micromamba} binaries installed
by \code{condathis}.
This argument is \strong{soft deprecated} as changing it don't really do anything.}

\item{additional_channels}{Character. Additional Channels to be added to the
default ones.}

\item{platform}{Character. Platform to search for \code{packages}.
Defaults to \code{NULL} which will use the current platform.
E.g. "linux-64", "linux-32", "osx-64", "win-64", "win-32", "noarch".
Note: on Apple Silicon MacOS will use "osx-64" instead of "osx-arm64"
if Rosetta 2 is available and any of the \code{packages} is not available
for "osx-arm64".}

\item{verbose}{Character string specifying the verbosity level of the function's output. Acceptable values are:
\itemize{
\item \strong{"silent"}: Suppress all output from internal command-line tools. Equivalent to \code{FALSE}.
\item \strong{"cmd"}: Print the internal command(s) passed to the command-line tool.
\item \strong{"output"}: Print the standard output and error from the command-line tool to the screen. Note that the order of the standard output and error lines may not be correct, as standard output is typically buffered. If the standard output and/or error is redirected to a file or they are ignored, they will not be echoed.
\item \strong{"full"}: Print both the internal command(s) (\code{"cmd"}) and their standard output and error (\code{"output"}). Equivalent to \code{TRUE}.
Logical values \code{FALSE} and \code{TRUE} are also accepted for backward compatibility but are \emph{soft-deprecated}. Please use \code{"silent"} and \code{"full"} respectively instead.
}}

\item{overwrite}{Logical. Should environment always be overwritten?
Defaults to \code{FALSE}.}
}
\value{
An object of class \code{list} representing the result of the command
execution. Contains information about the standard output, standard error,
and exit status of the command.
}
\description{
Create Conda Environment with specific packages installed to be used by \code{run()}.
}
\examples{
\dontrun{
condathis::with_sandbox_dir({
  # Create a Conda environment and install the CLI `fastqc` in it.
  condathis::create_env(
    packages = "fastqc==0.12.1",
    env_name = "fastqc-env",
    verbose = "output"
  )
  #> ! Environment fastqc-env succesfully created.
})
}
}
