% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateItems.R
\name{genItems}
\alias{genItems}
\title{genItems}
\usage{
genItems(n, scores = NULL, deltadots, taus, discrims = 1, centre = NULL)
}
\arguments{
\item{n}{How many items?}

\item{scores}{When NULL it is assumed that all items have
integer scoring, increasing for each category k, and beginning from 0.
Otherwise a list where the elements are, in order:
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the scores).
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function.
\item a boolean indicating whether the scores should be forced to be increasing across the response
categories.
\item optionally a vector of item numbers to apply scores too. If not provided it is assumed that all items
will be scored.
}}

\item{deltadots}{A list that describes the sampling distribution from which
item location paramters are drawn. The elements of the list are, in order:
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the delta dots).
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function.
If the argument is missing, item location distribution is assumed to be ~U(-2, 2).
}}

\item{taus}{A list that describes the sampling distribution from which taus
are drawn. Taus are deviations away from the average item location parameter.
The elements of the list are, in order:
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the taus).
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function.
\item a Boolean indicating whether the taus should be forced to be increasing across the response
category boundaries (that is, no items exhibit disordered thresholds).
\item optionally, a vector that describes the number of response categories to apply
to each of the \code{n} items being sampled.
The length of this vector must be equal to \code{n}.
For example if \code{n}=10, and the first 5 items are polytomous,
then a vector of length 10, e.g., c(3, 3, 3, 4, 5, 2, 2, 2, 2, 2).
In this example, the first three items have 3 categories each, the fourth item
has 4 categories, the fifth item 5 categories, and the last five items are all
dichotomies. When missing, a random vector is generated from
\code{sample(c(2:5), 10, replace = TRUE, prob = c(0.4, 0.3, 0.2, 0.1))} to create a
mix of dichotomous and polytomous items.
When the argument is missing, all items are assumed to be dichotomies.
}}

\item{discrims}{A list that describes the sampling distribution from which discrimination
parameters are drawn.
\itemize{
\item a string naming a distribution function (for example \code{runif}, \code{rnorm}) to generate random deviates
from (the discriminations).
\item a list of parameters to pass to the distribution function (for example, for \code{runif}, a list of
length 2 defining "min" and "max"). This list is assumed to be in order to be directly passed into
the function.
\item a Boolean indicating whether the discriminations are forced to be positive.
\item a Boolean indicating whether the discrimination is constant within item. When FALSE
a unique discrimination is sampled for each category
(that is, this can be one way of specifying the Bock Nominal model).
\item optionally a vector of item indices to sample a discrimination for.
The length of this vector must be equal to or less than \code{n}.
For example if \code{n}=10, and the user wants to sample discriminations for
items 1, 5, and 10 then the vector is c(1, 5, 10). All other items will have
a discrimination of 1. Otherwise it is assumed that all items
have sampled discriminations.
When missing all items are assumed to have constant discrimination equal to 1.
}}

\item{centre}{A number indicating the value to centre the generated values in deltadots on.
Typically 0 for identification purposes.
If NULL then values are left at their generated values (e.g., deviating from the expected mean
proportional to sampling error).}
}
\value{
A list of item matrices.
}
\description{
Generates a list of item parameter matrices for use in
function like \code{conquestr::genResponses} and \code{conquestr::informationWrightMap}
}
\examples{
  myItem <- matrix(c(0, 0, 0, 0, 1, 1, 0, 1), ncol = 4, byrow = TRUE)
  myItems <- list(myItem, myItem)
  myItems[[2]][2, 2] <- -1 # make the second item delta equal to -1
  myResponses <- genResponses(abilities = rnorm(100), itemParams = myItems)
}
\seealso{
\code{\link[=simplef]{simplef()}}, \code{\link[=genResponses]{genResponses()}}, \code{browseVignettes("conquestr")}
}
