% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_functions.R
\name{credsetC}
\alias{credsetC}
\title{Credible set of variants from matrix of PPs}
\usage{
credsetC(pp, CV, thr)
}
\arguments{
\item{pp}{Matrix of posterior probabilities of causality (one row per system)}

\item{CV}{Vector of CV indices (one per system/row)}

\item{thr}{Minimum threshold for credible set size}
}
\value{
Data.frame of claimed coverage (sum of posterior probabilities of variants in the set), binary covered indicator and number of variants (nvar).
}
\description{
Quick credset function for matrix of posterior probabilities (using RCpp)
}
\examples{

set.seed(1)
nsnps <- 100

# simulate matrix of posterior probabilities
# 1 simulation per row

pp <- matrix(rnorm(nsnps*100, 0.3, 0.05), ncol = nsnps)
pp <- pp/rowSums(pp)

iCV <- rep(71, times = dim(pp)[1])

credsetC(pp, CV = iCV, thr = 0.9)

}
