% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{correlate}
\alias{correlate}
\title{Correlation Data Frame}
\usage{
correlate(
  x,
  y = NULL,
  use = "pairwise.complete.obs",
  method = "pearson",
  diagonal = NA,
  quiet = FALSE
)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with
    compatible dimensions to \code{x}.   The default is equivalent to
    \code{y = x} (but more efficient).}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}

\item{method}{a character string indicating which correlation
    coefficient (or covariance) is to be computed.  One of
    \code{"pearson"} (default), \code{"kendall"}, or \code{"spearman"}:
    can be abbreviated.}

\item{diagonal}{Value (typically numeric or NA) to set the diagonal to}

\item{quiet}{Set as TRUE to suppress message about \code{method} and \code{use}
parameters.}
}
\value{
A correlation data frame \code{cor_df}
}
\description{
An implementation of stats::cor(), which returns a correlation data frame
rather than a matrix. See details below. Additional adjustment include the
use of pairwise deletion by default.
}
\details{
This function returns a correlation matrix as a correlation data frame in
the following format:

\itemize{
\item A tibble (see \code{\link[tibble]{tibble}})
\item An additional class, "cor_df"
\item A "term" column
\item Standardized variances (the matrix diagonal) set to missing values by
default (\code{NA}) so they can be ignored in calculations.
}

The \code{use} argument and its possible values are inherited from \code{stats::cor()}:

\itemize{
\item "everything": NAs will propagate conceptually, i.e. a resulting value will be NA whenever one of its contributing observations is NA
\item "all.obs": the presence of missing observations will produce an error
\item "complete.obs": correlations will be computed from complete observations, with an error being raised if there are no complete cases.
\item "na.or.complete": correlations will be computed from complete observations, returning an NA if there are no complete cases.
\item "pairwise.complete.obs": the correlation between each pair of variables is computed using all complete pairs of those particular variables.
}

As of version 0.4.3, the first column of a \code{cor_df} object is named "term".
In previous versions this first column was named "rowname".

There is a \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}} method for quickly visualizing the
correlation matrix, for more information see \code{\link[=autoplot.cor_df]{autoplot.cor_df()}}.
}
\examples{
\dontrun{
correlate(iris)
}

correlate(iris[-5])

correlate(mtcars)
\dontrun{

# Also supports DB backend and collects results into memory

library(sparklyr)
sc <- spark_connect(master = "local")
mtcars_tbl <- copy_to(sc, mtcars)
mtcars_tbl \%>\%
  correlate(use = "pairwise.complete.obs", method = "spearman")
spark_disconnect(sc)
}

}
