% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{state_census}
\alias{state_census}
\title{State population data}
\format{
Data frame with 53 rows (including one for the United States as a
whole, plus the District of Columbia and the Puerto Rico Commonwealth).
Important columns:

\describe{
\item{SUMLEV}{Geographic summary level.}
\item{REGION}{Census Region code}
\item{DIVISION}{Census Division code}
\item{STATE}{State FIPS code}
\item{NAME}{Name of the state}
\item{POPESTIMATE2019}{Estimate of the state's resident population in
2019.}
\item{POPEST18PLUS2019}{Estimate of the state's resident population in
2019 that is over 18 years old.}
\item{PCNT_POPEST18PLUS}{Estimate of the percent of a state's resident
population in 2019 that is over 18.}
\item{ABBR}{Postal abbreviation of the state}
}
}
\source{
United States Census Bureau, at
\url{https://www2.census.gov/programs-surveys/popest/datasets/2010-2019/counties/totals/co-est2019-alldata.pdf},
\url{https://www.census.gov/data/tables/time-series/demo/popest/2010s-total-puerto-rico-municipios.html},
and \url{https://www.census.gov/data/tables/2010/dec/2010-island-areas.html}
}
\usage{
state_census
}
\description{
Data set on state populations, from the 2019 US Census.
}
\seealso{
\code{\link[=abbr_to_name]{abbr_to_name()}}, \code{\link[=name_to_abbr]{name_to_abbr()}}, \code{\link[=abbr_to_fips]{abbr_to_fips()}}, \code{\link[=fips_to_abbr]{fips_to_abbr()}}
}
\keyword{datasets}
