% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestTD-class}
\alias{NextBestTD-class}
\alias{.NextBestTD}
\alias{NextBestTD}
\alias{.DefaultNextBestTD}
\title{\code{NextBestTD}}
\usage{
.DefaultNextBestTD()

NextBestTD(prob_target_drt, prob_target_eot)
}
\arguments{
\item{prob_target_drt}{(\code{proportion})\cr see slot definition.}

\item{prob_target_eot}{(\code{proportion})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{NextBestTD}} is the class to find a next best dose based on pseudo
DLT model without samples. Namely, it is to find two next best doses, one
for allocation during the trial and the second for final recommendation at
the end of a trial without involving any samples, i.e. only DLT responses
will be incorporated for the dose-allocation. This is based solely on the
probabilities of the occurrence of a DLT obtained by using the modal estimates
of the model parameters. There are two target probabilities of the
occurrence of a DLT that must be specified: target probability to be used
during the trial and target probability to be used at the end of the trial.
It is suitable to use it only with the \code{\link{ModelTox}} model class.
}
\section{Slots}{

\describe{
\item{\code{prob_target_drt}}{(\code{proportion})\cr the target probability (except 0 or 1)
of the occurrence of a DLT to be used during the trial.}

\item{\code{prob_target_eot}}{(\code{proportion})\cr the target probability (except 0 or 1)
of the occurrence of a DLT to be used at the end of the trial.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestTD()} function.
}
\examples{
my_next_best <- NextBestTD(0.35, 0.3)
}
