% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection-config.R
\name{set_integer_promotion}
\alias{set_integer_promotion}
\title{Tag a connection with the preferred integer promotion method for types
larger that R's integer type i.e. uint32, uint64, int64}
\usage{
set_integer_promotion(con, uint32 = "dbl", int64 = "dbl", uint64 = "dbl")
}
\arguments{
\item{con}{Connection object or raw vector. Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{uint32, int64, uint64}{specifiy separate promotion methods for these types
One of: 'dbl', 'hex', 'raw' and 'bit64' (for 64-bit types only) Default: 'dbl'.
This default may be over-ridden by specifying
the \code{promote} argument when calling individual functions.
\describe{
  \item{\code{dbl}}{Read in integers as doubles. Integer values above 2^53
  will lose precision.}
  \item{\code{hex}}{Each integer is returned as a
  hexadecimal string}
  \item{\code{raw}}{A single raw vector containing all the integers 
  in their original form}
  \item{\code{bit64}}{Return an \code{integer64} vector compatible with the
  \code{bit64} package.  Note. \code{integer64} is a \emph{signed} 64-bit
  integer}
}}
}
\value{
Modified connection object
}
\description{
Tag a connection with the preferred integer promotion method for types
larger that R's integer type i.e. uint32, uint64, int64
}
\examples{
# Open a connection and configure it so all 'uint32' values are 
# read as floating point and all all 'uint64' values are read as hexadecimal strings
con <- rawConnection(as.raw(c(1:7, 0, 1:7, 0, 1:7, 0, 1:7, 0)), "rb")
con <- set_integer_promotion(con, uint32 = "dbl", uint64 = "hex")

# Future reads of uint64 will return hex strings
read_uint64(con, n = 2)

# Unless over-ridden during the read
read_uint64(con, n = 1, promote = "dbl")

close(con)

}
\seealso{
Other connection configuration functions: 
\code{\link{set_bounds_check}()},
\code{\link{set_endian}()},
\code{\link{set_eof_check}()},
\code{\link{set_na_check}()}
}
\concept{connection configuration functions}
