% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxhull.R
\name{EdgesAB}
\alias{EdgesAB}
\title{Edges of a triangulated 3D convex hull}
\usage{
EdgesAB(hull)
}
\arguments{
\item{hull}{an output of \code{\link{cxhull}} applied to 3D points and 
with the option \code{triangulate=TRUE}}
}
\value{
A character matrix with three columns. Each row provides the ids of 
  the two vertices of an edge, and a yes/no indicator of whether the edge 
  is a border edge.
}
\description{
Edges of a triangulated 3D convex hull given by the ids of 
  the vertices in a matrix, plus a column indicating the border edges.
}
\examples{
library(cxhull)
library(rgl)
dodecahedron <- t(dodecahedron3d()$vb[-4L, ])
hull <- cxhull(dodecahedron, triangulate = TRUE)
triangles <- TrianglesXYZ(hull)
triangles3d(triangles, color = "yellow")
edges <- EdgesAB(hull)
trueEdges <- edges[edges[, 3L] == "yes", c(1L, 2L)]
otherEdges <- edges[edges[, 3L] == "no", c(1L, 2L)]
vertices <- VerticesXYZ(hull)
for(i in 1:nrow(trueEdges)){
  lines3d(vertices[trueEdges[i, ], ], color = "blue", lwd = 3)
}
for(i in 1:nrow(otherEdges)){
  lines3d(vertices[otherEdges[i, ], ], color = "red", lwd = 3)
}
}
