% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_eigenvalues.R
\name{graph_eigenvalues.matrix}
\alias{graph_eigenvalues.matrix}
\title{A helper for sub_dann}
\usage{
\method{graph_eigenvalues}{matrix}(
  x,
  y,
  neighborhood_size = max(floor(nrow(x)/5), 50),
  weighted = FALSE,
  sphere = "mcd",
  ...
)
}
\arguments{
\item{x}{A matrix.}

\item{y}{A vector.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{...}{Additional parameters passed to methods.}
}
\value{
A ggplot2 graph.
}
\description{
A helper for sub_dann
}
\details{
This function plots the eigenvalues found by \code{\link[fpc:ncoord]{fpc::ncoord()}}. The user
should make a judgement call on how many eigenvalues are large and set sub_dann's
numDim to that number.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)

set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")

# Add 5 unrelated variables
train <- train \%>\%
  mutate(
    U1 = runif(300, -1, 1),
    U2 = runif(300, -1, 1),
    U3 = runif(300, -1, 1),
    U4 = runif(300, -1, 1),
    U5 = runif(300, -1, 1)
  )

y <- as.numeric(train$Y)
x <- cbind(train$X1, train$X2, train$U1, train$U2, train$U3, train$U4, train$U5)

graph_eigenvalues(x, y)
}
