% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_yearmonth.R
\name{dp_to_yearmonth}
\alias{dp_to_yearmonth}
\title{Convert a vector to 'yearmonth' using the specified field descriptor}
\usage{
dp_to_yearmonth(x, fielddescriptor = list(), ...)
}
\arguments{
\item{x}{the vector to convert.}

\item{fielddescriptor}{the field descriptor for the field.}

\item{...}{passed on to other methods.}
}
\value{
Will return an \code{Date} vector with \code{fielddescriptor} added as the
'fielddescriptor' attribute. The dates will be the first of the given month.
Therefore, a 'yearmonth' "2024-05" is translated to a date "2024-05-01".
}
\description{
Convert a vector to 'yearmonth' using the specified field descriptor
}
\details{
When \code{fielddescriptor} is missing a default field descriptor is
generated.

Valid formats are "YYYY-MM" or "YYYYMM". When x is numeric or integer, it is
assumed that it was a yearmonth in the format "YYYYMM" that was accidentally
converted to numeric format.
}
