% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_map_by_largest_prefix.R
\name{util_map_by_largest_prefix}
\alias{util_map_by_largest_prefix}
\title{Map based on largest common prefix}
\usage{
util_map_by_largest_prefix(
  needle,
  haystack,
  split_char = "_",
  remove_var_suffix = TRUE
)
}
\arguments{
\item{needle}{\link{character}\code{(1)} item to search}

\item{haystack}{\link{character} items to find the entry sharing the largest
prefix with \code{needle}}

\item{split_char}{\link{character}\code{(1)} to split entries to atomic words (like
letters, if "" or \code{snake_elements}, if "_")}

\item{remove_var_suffix}{\link{logical}\code{(1)} remove potential suffix
after the first dot \code{.}, before
finding needle in haystack.}
}
\value{
\link{character}\code{(1)} with the fitting function name or \link{NA_character_}
}
\description{
Map based on largest common prefix
}
\examples{
\dontrun{ # internal function
util_map_by_largest_prefix(
  "acc_distributions_loc_ecdf_observer_time",
  names(dataquieR:::.manual$titles)
)
util_map_by_largest_prefix(
  "acc_distributions_loc_observer_time",
  names(dataquieR:::.manual$titles)
)
util_map_by_largest_prefix(
  "acc_distributions_loc_ecdf",
  names(dataquieR:::.manual$titles)
)
util_map_by_largest_prefix(
  "acc_distributions_loc",
  names(dataquieR:::.manual$titles)
)
}

}
\seealso{
Other mapping: 
\code{\link{util_map_all}()},
\code{\link{util_map_labels}()},
\code{\link{util_recode}()}
}
\concept{concept}
\concept{mapping}
\keyword{internal}
