% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{plot.deform}
\alias{plot.deform}
\title{Plot a fitted \code{deform} object}
\usage{
\method{plot}{deform}(
  x,
  start = 1,
  graphics = "base",
  breaks = NULL,
  pal = function(n) hcl.colors(n, "YlOrRd", rev = TRUE),
  onepage = FALSE,
  nx = 10,
  ny = 10,
  xp = NULL,
  yp = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{a fitted \code{deform} object}

\item{start}{an integer giving the starting dimension of plots of dimension expansion models; defaults to 1}

\item{graphics}{a character string that is either \code{"graphics"} or \code{"lattice"} and states the graphics package to use for plots; defaults to \code{"graphics"}}

\item{breaks}{an integer, vector or list; see Details}

\item{pal}{a function specifying the colour palette to use for plots; defaults to \code{hcl.colors(..., 'YlOrRd', rev = TRUE)}}

\item{onepage}{a logical specifying whether all plots should be put on one page; defaults to \code{FALSE}, which makes use of the current graphics state}

\item{nx}{number of x points to use for plotting grid}

\item{ny}{number of y points to use for plotting grid}

\item{xp}{x points to use for plotting grid}

\item{yp}{y points to use for plotting grid}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{...}{extra arguments to pass to \code{plot()}}
}
\value{
Plots representing all one- or two-dimensional smooths
}
\description{
Plot a fitted \code{deform} object
}
\details{
If \code{breaks} is an integer then it specifies the number of breaks to use for colour scales; if it's a vector, then it's the breaks themselves; and if it's a list then it's different breaks for each dimension.
}
\examples{

\donttest{

# deformations
data(solar)
m0 <- deform(solar$x, solar$z, solar$n)

# plot representation of deformation
plot(m0)

# as above with specified x and y grid
xvals <- seq(-123.3, -122.25, by = .05)
yvals <- seq(49, 49.4, by = .05)
plot(m0, xp = xvals, yp = yvals)

}

# one-dimensional expansion
data(solar)
m1 <- expand(solar$x, solar$z, solar$n)

# plot its three dimensions
op <- par(mfrow = c(1, 3))
plot(m1)
par(op)

# or plot using lattice::levelplot
plot(m1, graphics = 'lattice')
# or as above, but on one page
plot(m1, graphics = 'lattice', onepage = TRUE)

\donttest{

# two-dimensional expansion
m2 <- expand(solar$x, solar$z, solar$n, c(8, 5)) 
# plot of its third and fourth dimensions for given x and y values
op <- par(mfrow = c(1, 2))
plot(m2, start = 3, xp = xvals, yp = yvals)
par(op)

# using lattice::levelplot with common breaks across dimensions with
# a palette that gives latent dimensions in white where near zero
plot(m2, onepage = TRUE, graphics = 'lattice', breaks = seq(-0.35, 0.35, by = 0.1), 
     pal = function(n) hcl.colors(n, 'Blue-Red 3'))
     
}

}
