% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty.R
\name{pretty_filesize}
\alias{pretty_filesize}
\title{Pretty numbers into readable file size}
\usage{
pretty_filesize(filesize)
}
\arguments{
\item{filesize}{file size in bytes}
}
\value{
string containing prettified file size
}
\description{
Converts a raw file size from bytes to a more readable format.
}
\details{
Designed to be used in conjunction with the file.size()
function in base R.

Presents in kilobytes, megabytes or gigabytes.

Shows as bytes until 1 KB, then kilobytes up to 1 MB, then megabytes
until 1GB, then it will show as gigabytes for anything larger.

Rounds the end result to 2 decimal places.

Using base 10 (decimal), so 1024 bytes is 1,024 KB.
}
\examples{
pretty_filesize(2)
pretty_filesize(549302)
pretty_filesize(9872948939)
pretty_filesize(1)
pretty_filesize(1000)
pretty_filesize(1000^2)
pretty_filesize(10^9)
}
\seealso{
\code{\link[=comma_sep]{comma_sep()}} \code{\link[=round_five_up]{round_five_up()}}

Other prettying: 
\code{\link{pretty_num}()},
\code{\link{pretty_num_table}()},
\code{\link{pretty_time_taken}()}
}
\concept{prettying}
