% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{trim_DF}
\alias{trim_DF}
\title{Trim data frame}
\usage{
trim_DF(data, trim.var.name, trim.action, trim.thresh)
}
\arguments{
\item{data}{data frame}

\item{trim.var.name}{character; vector of data frame column names with numeric variables that should be tested for conditions}

\item{trim.action}{character; vector of test conditions; possible values are:
\code{"more", "eqmore"} (more or equal), \code{"less", "eqless"} (less or equal).}

\item{trim.thresh}{numeric; vector of condition threshold values}
}
\value{
data frame without rows with values that do not satisfy the specified conditions.
}
\description{
If the numeric value of the data frame variable does not meet the specified conditions, the function deletes the entire row.
}
\details{
This function takes the vector of data frame variables and for each of them test if they satisfy the specified conditions.
Not satisfying values are deleted with the entire data frame row. You may set as many conditions for as many variables as you like.

\code{trim.values} must be exact column names as in data frame.
}
\examples{
data <- data.frame ("a" = 1:10, "b" = 101:110)
trim_DF (data, trim.var.name = c("a", "b"), trim.action = c("less", "eqmore"),
       trim.thresh = c(6, 104))

}
\author{
Elena N. Filatova
}
