% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique-keys.R
\name{dm_rm_uk}
\alias{dm_rm_uk}
\title{Remove a unique key}
\usage{
dm_rm_uk(dm, table = NULL, columns = NULL, ...)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{A table in the \code{dm}.
Pass \code{NULL} to remove all matching keys.}

\item{columns}{Table columns, unquoted.
To refer to a compound key, use \code{c(col1, col2)}.
Pass \code{NULL} (the default) to remove all matching keys.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
An updated \code{dm} without the indicated unique key(s).
}
\description{
\code{dm_rm_uk()} removes one or more unique keys from a table and leaves the \code{\link{dm}} object otherwise unaltered.
An error is thrown if no unique key matches the selection criteria.
If the selection criteria are ambiguous, a message with unambiguous replacement code is shown.
Foreign keys are never removed.
}
\seealso{
Other primary key functions: 
\code{\link{dm_add_pk}()},
\code{\link{dm_add_uk}()},
\code{\link{dm_get_all_pks}()},
\code{\link{dm_get_all_uks}()},
\code{\link{dm_has_pk}()},
\code{\link{dm_rm_pk}()},
\code{\link{enum_pk_candidates}()}
}
\concept{primary key functions}
